// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.base;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import com.appslandia.common.utils.ObjectUtils;

/**
 *
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 *
 */
public class JdkSerializer extends JavaSerializer {

	final int byteChunksBlockSize;

	public JdkSerializer() {
		this(512);
	}

	public JdkSerializer(int byteChunksBlockSize) {
		this.byteChunksBlockSize = byteChunksBlockSize;
	}

	@Override
	public ByteChunks serialize(Object obj) throws JavaSerializerException {
		try {
			ByteChunks bc = new ByteChunks(this.byteChunksBlockSize);
			ObjectOutputStream oos = new ObjectOutputStream(bc);
			oos.writeObject(obj);
			oos.flush();
			return bc;

		} catch (IOException ex) {
			throw new JavaSerializerException(ex);
		}
	}

	@Override
	public <T> T deserialize(byte[] ser) throws JavaSerializerException {
		try {
			ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(ser));
			return ObjectUtils.cast(ois.readObject());

		} catch (Exception ex) {
			throw new JavaSerializerException(ex);
		}
	}
}
