/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.validators;

import com.appslandia.common.utils.MathUtils;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ConstraintValidatorImpl.class})
@Documented
public @interface BitMask {
    public String message() default "{com.appslandia.common.validators.BitMask.message}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public int value() default 0;

    public static class ConstraintValidatorImpl
    implements ConstraintValidator<BitMask, Number> {
        private int length;

        public void initialize(BitMask annotation) {
            this.length = annotation.value();
        }

        public boolean isValid(Number value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            int intValue = value.intValue();
            if (intValue < 0) {
                return false;
            }
            return this.length <= 0 || intValue < MathUtils.pow2(this.length);
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public BitMask[] value();
    }
}

