/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.ConfigBase;
import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.base.FormatProviderImpl;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.FormatterProvider;
import com.appslandia.common.utils.ReflectionException;
import com.appslandia.common.utils.ReflectionUtils;
import com.appslandia.common.utils.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class PropertyUtils {
    public static final PropertyStrategy METHOD_PROPERTY_STRATEGY = new PropertyStrategy(){

        @Override
        public Method find(Class<?> clazz, final String propertyName) {
            return ReflectionUtils.traverse(clazz, new ReflectionUtils.MethodMatcher(){

                @Override
                public boolean match(Method m) {
                    if (!Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers())) {
                        return false;
                    }
                    if (m.getParameterTypes().length != 1) {
                        return false;
                    }
                    return m.getName().equals(propertyName);
                }
            }, ReflectionUtils.FIND_METHOD_TRAVERSER);
        }
    };
    public static final PropertyStrategy BEAN_PROPERTY_STRATEGY = new PropertyStrategy(){

        @Override
        public Method find(Class<?> clazz, final String propertyName) {
            return ReflectionUtils.traverse(clazz, new ReflectionUtils.MethodMatcher(){

                @Override
                public boolean match(Method m) {
                    if (!Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers())) {
                        return false;
                    }
                    if (m.getParameterTypes().length != 1) {
                        return false;
                    }
                    return m.getName().equals("set" + StringUtils.firstUpperCase(propertyName));
                }
            }, ReflectionUtils.FIND_METHOD_TRAVERSER);
        }
    };

    public static void initialize(Object obj, ConfigBase props, PropertyStrategy propertyStrategy) throws FormatterException, ReflectionException {
        PropertyUtils.initialize(obj, props, new FormatProviderImpl(), propertyStrategy);
    }

    public static void initialize(Object obj, ConfigBase props, FormatProvider formatProvider, PropertyStrategy propertyStrategy) throws FormatterException, ReflectionException {
        for (String prop : props.getKeys()) {
            Method m = propertyStrategy.find(obj.getClass(), prop);
            if (m == null) continue;
            Class<?> parameterType = m.getParameterTypes()[0];
            if (parameterType == String.class) {
                ReflectionUtils.invoke(m, obj, props.getString(prop));
                continue;
            }
            Formatter formatter = FormatterProvider.getDefault().getFormatter(parameterType);
            Object value = formatter.parse(props.getString(prop), formatProvider);
            ReflectionUtils.invoke(m, obj, value);
        }
    }

    private static interface PropertyStrategy {
        public Method find(Class<?> var1, String var2);
    }
}

