/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.DateUtils;
import com.appslandia.common.utils.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;

public class FileUtils {
    public static String insertNow(String fileName) {
        String now = DateUtils.format(new Date(), "yyyyMMdd-HHmmss");
        int idx = fileName.lastIndexOf(46);
        if (idx < 0) {
            return fileName + "-" + now;
        }
        if (idx == 0) {
            return now + fileName;
        }
        return fileName.substring(0, idx) + "-" + now + fileName.substring(idx);
    }

    public static String insertExtra(String fileName, String extra) {
        int idx = fileName.lastIndexOf(46);
        if (idx < 0) {
            return fileName + extra;
        }
        if (idx == 0) {
            return extra + fileName;
        }
        return fileName.substring(0, idx) + extra + fileName.substring(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dest) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            IOUtils.copy(fis, fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static byte[] readAllBytes(File src) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(src);
            byte[] byArray = IOUtils.toByteArray(fis);
            return byArray;
        }
    }
}

