/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.DateFormatException;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class DateUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss.SSS";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String TIME_FORMAT_Z = "HH:mm:ss.SSSXXX";
    public static final String DATETIME_FORMAT_Z = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final long __1SEC_MS = 1000L;
    public static final long __1MIN_MS = 60000L;
    public static final long __1HR_MS = 3600000L;
    public static final long __1D_MS = 86400000L;
    public static final long __1WK_MS = 604800000L;
    private static final Pattern TEMPORAL_AMT_PATTERN = Pattern.compile("(\\d+(wk|d|hr|min|sec|ms)\\s*)+", 2);

    public static long translateToMs(String temporalAmt) throws IllegalArgumentException {
        temporalAmt = StringUtils.trimToNull(temporalAmt);
        AssertUtils.assertNotNull(temporalAmt, "temporalAmt is required.");
        AssertUtils.assertTrue(TEMPORAL_AMT_PATTERN.matcher(temporalAmt).matches(), "temporalAmt is invalid format.");
        long result = 0L;
        int i = 0;
        while (i < temporalAmt.length()) {
            int k;
            int j = i;
            while (Character.isDigit(temporalAmt.charAt(j))) {
                ++j;
            }
            for (k = j; k <= temporalAmt.length() - 1 && (Character.isLetter(temporalAmt.charAt(k)) || temporalAmt.charAt(k) == ' '); ++k) {
            }
            int amt = Integer.parseInt(temporalAmt.substring(i, j));
            String unit = temporalAmt.substring(j, k).trim();
            result = "wk".equalsIgnoreCase(unit) ? (result += 604800000L * (long)amt) : ("d".equalsIgnoreCase(unit) ? (result += 86400000L * (long)amt) : ("hr".equalsIgnoreCase(unit) ? (result += 3600000L * (long)amt) : ("min".equalsIgnoreCase(unit) ? (result += 60000L * (long)amt) : ("sec".equalsIgnoreCase(unit) ? (result += 1000L * (long)amt) : (result += (long)amt)))));
            i = k;
        }
        return result;
    }

    public static Map<TimeUnit, Long> parseUnits(long durationMs, TimeUnit start, TimeUnit end) {
        return DateUtils.parseUnits(durationMs, TimeUnit.MILLISECONDS, start, end);
    }

    public static Map<TimeUnit, Long> parseUnits(long duration, TimeUnit unit, TimeUnit start, TimeUnit end) {
        AssertUtils.assertTrue(start.compareTo(end) >= 0);
        EnumMap<TimeUnit, Long> map = new EnumMap<TimeUnit, Long>(TimeUnit.class);
        long ms = TimeUnit.MILLISECONDS.convert(duration, unit);
        TimeUnit u = start;
        while (true) {
            long v = u.convert(ms, TimeUnit.MILLISECONDS);
            map.put(u, v);
            if (u == end) break;
            ms -= TimeUnit.MILLISECONDS.convert(v, u);
            u = DateUtils.nextUnit(u);
        }
        return map;
    }

    private static TimeUnit nextUnit(TimeUnit unit) {
        switch (unit) {
            case DAYS: {
                return TimeUnit.HOURS;
            }
            case HOURS: {
                return TimeUnit.MINUTES;
            }
            case MINUTES: {
                return TimeUnit.SECONDS;
            }
            case SECONDS: {
                return TimeUnit.MILLISECONDS;
            }
        }
        throw new IllegalArgumentException();
    }

    public static long timeMillisAt(int days) {
        return System.currentTimeMillis() + (long)days * 86400000L;
    }

    public static java.sql.Date today() {
        return new java.sql.Date(DateUtils.todayCalendar().getTimeInMillis());
    }

    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Calendar todayCalendar() {
        GregorianCalendar cal = new GregorianCalendar();
        DateUtils.clearTime(cal);
        return cal;
    }

    public static Calendar nowCalendar() {
        return new GregorianCalendar();
    }

    public static Calendar getCalendar(int dayOfWeek, int atHour, int atMinute) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(7, dayOfWeek);
        cal.set(11, atHour);
        cal.set(12, atMinute);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Date copyTime(Date toDate, Date fromDate) {
        GregorianCalendar toCal = new GregorianCalendar();
        toCal.setTime(toDate);
        GregorianCalendar fromCal = new GregorianCalendar();
        fromCal.setTime(fromDate);
        toCal.set(11, fromCal.get(11));
        toCal.set(12, fromCal.get(12));
        toCal.set(13, fromCal.get(13));
        toCal.set(14, fromCal.get(14));
        return toCal.getTime();
    }

    public static Date clearTime(Date d) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        DateUtils.clearTime(cal);
        return cal.getTime();
    }

    public static void clearTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static long clearMillis(long timeInMillis) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(timeInMillis);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static String format(Date temporal, String pattern) {
        return DateUtils.newDateFormat(pattern).format(temporal);
    }

    public static SimpleDateFormat newDateFormat(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setLenient(false);
        return sdf;
    }

    public static java.sql.Date iso8601Date(String date) throws DateFormatException {
        return date != null ? new java.sql.Date(DateUtils.parse(date, DATE_FORMAT).getTime()) : null;
    }

    public static String iso8601Date(Date date) {
        return date != null ? DateUtils.newDateFormat(DATE_FORMAT).format(date) : null;
    }

    public static Time iso8601Time(String time) throws DateFormatException {
        return time != null ? new Time(DateUtils.parse(time, TIME_FORMAT).getTime()) : null;
    }

    public static String iso8601Time(Date time) {
        return time != null ? DateUtils.newDateFormat(TIME_FORMAT).format(time) : null;
    }

    public static Timestamp iso8601DateTime(String dateTime) throws DateFormatException {
        return dateTime != null ? new Timestamp(DateUtils.parse(dateTime, DATETIME_FORMAT).getTime()) : null;
    }

    public static String iso8601DateTime(Date dateTime) {
        return dateTime != null ? DateUtils.newDateFormat(DATETIME_FORMAT).format(dateTime) : null;
    }

    private static Date parse(String temporal, String pattern) throws DateFormatException {
        try {
            return DateUtils.newDateFormat(pattern).parse(temporal);
        }
        catch (ParseException ex) {
            throw new DateFormatException(ex);
        }
    }
}

