/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jdbc;

import com.appslandia.common.base.CaseInsensitiveMap;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.utils.AssertUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class Sql
extends InitializeObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sql;
    private Map<String, Integer> arrayLens;
    private String translatedSql;
    private Map<String, int[]> indexesMap;

    public Sql() {
    }

    public Sql(String sql) {
        this.sql = sql;
    }

    public Sql arrayParam(String parameterName, int length) {
        this.assertNotInitialized();
        AssertUtils.assertTrue(length > 0, "length is required.");
        if (this.arrayLens == null) {
            this.arrayLens = new CaseInsensitiveMap<Integer>();
        }
        this.arrayLens.put(parameterName, length);
        return this;
    }

    public Sql sql(String sql) {
        this.assertNotInitialized();
        this.sql = sql;
        return this;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.sql, "sql is required.");
        this.translateSql();
    }

    private void translateSql() {
        int j;
        StringBuilder sb = new StringBuilder(this.sql);
        CaseInsensitiveMap<int[]> indexesMap = new CaseInsensitiveMap<int[]>();
        int i = 0;
        int index = 0;
        while (true) {
            int subIdx;
            int k;
            for (j = i; j < sb.length() - 1 && sb.charAt(j) != '@'; ++j) {
            }
            if (j >= sb.length() - 1 || !Character.isLetter(sb.charAt(j + 1))) break;
            for (k = j + 1; k < sb.length() && (Character.isLetterOrDigit(sb.charAt(k)) || sb.charAt(k) == '_'); ++k) {
            }
            String paramName = sb.substring(j + 1, k);
            sb.delete(j, k);
            Integer arrayLen = this.arrayLens == null ? null : this.arrayLens.get(paramName);
            int len = arrayLen == null ? 1 : arrayLen;
            for (subIdx = 0; subIdx < len; ++subIdx) {
                if (subIdx == 0) {
                    sb.insert(j, '?');
                    continue;
                }
                sb.insert(j, "?, ");
            }
            for (subIdx = 0; subIdx < len; ++subIdx) {
                String name = arrayLen == null ? paramName : paramName + subIdx;
                int[] indexes = (int[])indexesMap.get(name);
                if (indexes == null) {
                    indexes = new int[]{++index};
                } else {
                    indexes = Arrays.copyOf(indexes, indexes.length + 1);
                    indexes[indexes.length - 1] = ++index;
                }
                indexesMap.put(name, indexes);
            }
            i = j + len;
        }
        if (j < sb.length() - 1) {
            throw new IllegalArgumentException("sql is invalid.");
        }
        this.translatedSql = sb.toString();
        this.indexesMap = !indexesMap.isEmpty() ? indexesMap : Collections.emptyMap();
    }

    public String getSql() {
        this.initialize();
        return this.sql;
    }

    public String getTranslatedSql() {
        this.initialize();
        return this.translatedSql;
    }

    public int[] getIndexes(String parameterName) {
        this.initialize();
        int[] indexes = this.indexesMap.get(parameterName);
        if (indexes == null) {
            throw new IllegalArgumentException("Parameter is required (name=" + parameterName + ")");
        }
        return indexes;
    }

    public int getArrayLen(String parameterName) {
        Integer len;
        this.initialize();
        Integer n = len = this.arrayLens != null ? this.arrayLens.get(parameterName) : null;
        if (len == null) {
            throw new IllegalArgumentException("Array parameter is not registered (name=" + parameterName + ")");
        }
        return len;
    }
}

