/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashSet;

public class JdbcUtils {
    public static void closeQuietly(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Statement stat) {
        if (stat != null) {
            try {
                stat.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static String[] getColumnLabels(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        LinkedHashSet<String> labels = new LinkedHashSet<String>();
        for (int idx = 1; idx <= md.getColumnCount(); ++idx) {
            labels.add(md.getColumnLabel(idx));
        }
        return labels.toArray(new String[labels.size()]);
    }
}

