/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.gson;

import com.appslandia.common.utils.DateUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class SqlTimeAdapter
implements JsonSerializer<Time>,
JsonDeserializer<Time> {
    final SimpleDateFormat formatter = DateUtils.newDateFormat("HH:mm:ss.SSS");
    final SimpleDateFormat parser = DateUtils.newDateFormat("HH:mm:ss.SSS");
    final Object fmtMutex = new Object();
    final Object parMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonElement serialize(Time src, Type typeOfSrc, JsonSerializationContext context) {
        Object object = this.fmtMutex;
        synchronized (object) {
            return new JsonPrimitive(this.formatter.format(src));
        }
    }

    public Time deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Object object = this.parMutex;
        synchronized (object) {
            try {
                return new Time(this.parser.parse(json.getAsString()).getTime());
            }
            catch (ParseException ex) {
                throw new JsonParseException((Throwable)ex);
            }
        }
    }
}

