/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.formatters.BigDecimalFormatter;
import com.appslandia.common.formatters.BigIntegerFormatter;
import com.appslandia.common.formatters.BooleanFormatter;
import com.appslandia.common.formatters.ByteFormatter;
import com.appslandia.common.formatters.CharacterFormatter;
import com.appslandia.common.formatters.DoubleFormatter;
import com.appslandia.common.formatters.FloatFormatter;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.FormatterNamed;
import com.appslandia.common.formatters.IntegerFormatter;
import com.appslandia.common.formatters.LongFormatter;
import com.appslandia.common.formatters.ShortFormatter;
import com.appslandia.common.formatters.SqlDateFormatter;
import com.appslandia.common.formatters.SqlDateTime24HFormatter;
import com.appslandia.common.formatters.SqlDateTimeFormatter;
import com.appslandia.common.formatters.SqlTime24HFormatter;
import com.appslandia.common.formatters.SqlTimeFormatter;
import com.appslandia.common.utils.TypeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FormatterProvider
extends InitializeObject {
    public static final String INSTANCE_ID = "__formatterProvider";
    private Map<String, Formatter> formatterMap = new HashMap<String, Formatter>();

    public static FormatterProvider getDefault() {
        return FormatterProviderHolder.DEFAULT;
    }

    @Override
    protected void init() throws Exception {
        this.addDefault(Formatter.BYTE, new ByteFormatter());
        this.addDefault(Formatter.SHORT, new ShortFormatter());
        this.addDefault(Formatter.INTEGER, new IntegerFormatter());
        this.addDefault(Formatter.LONG, new LongFormatter());
        this.addDefault(Formatter.BIGINTEGER, new BigIntegerFormatter());
        this.addDefault(Formatter.FLOAT, new FloatFormatter());
        this.addDefault(Formatter.DOUBLE, new DoubleFormatter());
        this.addDefault(Formatter.BIGDECIMAL, new BigDecimalFormatter());
        this.addDefault(Formatter.SQL_DATE, new SqlDateFormatter());
        this.addDefault(Formatter.SQL_TIME, new SqlTimeFormatter());
        this.addDefault(Formatter.SQL_DATETIME, new SqlDateTimeFormatter());
        this.addDefault("Time24H", new SqlTime24HFormatter());
        this.addDefault("DateTime24H", new SqlDateTime24HFormatter());
        this.addDefault(Formatter.BOOLEAN, new BooleanFormatter());
        this.addDefault(Formatter.CHARACTER, new CharacterFormatter());
        this.formatterMap = Collections.unmodifiableMap(this.formatterMap);
    }

    protected void addDefault(String name, Formatter formatter) {
        if (!this.formatterMap.containsKey(name)) {
            this.formatterMap.put(name, formatter);
        }
    }

    public void addFormatter(String name, Formatter formatter) {
        this.assertNotInitialized();
        this.formatterMap.put(name, formatter);
    }

    public Formatter findFormatter(Class<?> targetType, FormatterNamed named) {
        this.initialize();
        if (named != null) {
            return this.getFormatter(named.value());
        }
        String name = TypeUtils.wrap(targetType).getSimpleName();
        return this.formatterMap.get(name);
    }

    public Formatter getFormatter(Class<?> targetType) throws IllegalArgumentException {
        this.initialize();
        String name = TypeUtils.wrap(targetType).getSimpleName();
        Formatter formatter = this.formatterMap.get(name);
        if (formatter == null) {
            throw new IllegalArgumentException("Formatter is required (targetType=" + targetType + ")");
        }
        return formatter;
    }

    public Formatter getFormatter(String name) throws IllegalArgumentException {
        this.initialize();
        Formatter formatter = this.formatterMap.get(name);
        if (formatter == null) {
            throw new IllegalArgumentException("Formatter is required (name=" + name + ")");
        }
        return formatter;
    }

    private static final class FormatterProviderHolder {
        static final FormatterProvider DEFAULT = new FormatterProvider();

        private FormatterProviderHolder() {
        }
    }
}

