/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.crypto.TextBasedCrypto;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.BaseEncodingUtils;
import java.nio.charset.Charset;

public class TextEncryptor
extends TextBasedCrypto {
    private Encryptor encryptor;

    public TextEncryptor() {
    }

    public TextEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        AssertUtils.assertNotNull(this.encryptor, "encryptor is required.");
    }

    public String encrypt(String message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        return BaseEncodingUtils.encode(this.encryptor.encrypt(message.getBytes(this.textCharset)), this.baseEncoding);
    }

    public String decrypt(String message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        return new String(this.encryptor.decrypt(BaseEncodingUtils.decode(message, this.baseEncoding)), this.textCharset);
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.encryptor != null) {
            this.encryptor.destroy();
        }
        super.destroy();
    }

    public TextEncryptor setEncryptor(Encryptor encryptor) {
        this.assertNotInitialized();
        this.encryptor = encryptor;
        return this;
    }

    @Override
    public TextEncryptor setTextCharset(Charset charset) {
        super.setTextCharset(charset);
        return this;
    }

    @Override
    public TextEncryptor setTextCharset(String textCharset) {
        super.setTextCharset(textCharset);
        return this;
    }

    @Override
    public TextEncryptor setBaseEncoding(String baseEncoding) {
        super.setBaseEncoding(baseEncoding);
        return this;
    }

    public TextEncryptor copy() {
        TextEncryptor impl = new TextEncryptor();
        impl.setTextCharset(this.textCharset).setBaseEncoding(this.baseEncoding);
        if (this.encryptor != null) {
            impl.encryptor = this.encryptor.copy();
        }
        return impl;
    }
}

