/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.crypto.TextBasedCrypto;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.BaseEncodingUtils;
import java.nio.charset.Charset;

public class TextDigester
extends TextBasedCrypto {
    private Digester digester;

    public TextDigester() {
    }

    public TextDigester(Digester digester) {
        this.digester = digester;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        AssertUtils.assertNotNull(this.digester, "digester is required.");
    }

    public String digest(String message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        return BaseEncodingUtils.encode(this.digester.digest(message.getBytes(this.textCharset)), this.baseEncoding);
    }

    public boolean verify(String message, String digested) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(digested, "digested is required.");
        return this.digester.verify(message.getBytes(this.textCharset), BaseEncodingUtils.decode(digested, this.baseEncoding));
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.digester != null) {
            this.digester.destroy();
        }
        super.destroy();
    }

    public TextDigester setDigester(Digester digester) {
        this.assertNotInitialized();
        this.digester = digester;
        return this;
    }

    @Override
    public TextDigester setTextCharset(Charset charset) {
        super.setTextCharset(charset);
        return this;
    }

    @Override
    public TextDigester setTextCharset(String textCharset) {
        super.setTextCharset(textCharset);
        return this;
    }

    @Override
    public TextDigester setBaseEncoding(String baseEncoding) {
        super.setBaseEncoding(baseEncoding);
        return this;
    }

    public TextDigester copy() {
        TextDigester impl = new TextDigester();
        impl.setTextCharset(this.textCharset).setBaseEncoding(this.baseEncoding);
        if (this.digester != null) {
            impl.digester = this.digester.copy();
        }
        return impl;
    }
}

