/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.PropertyConfig;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.crypto.PbeEncryptor;
import com.appslandia.common.crypto.TextEncryptor;
import com.appslandia.common.utils.CharsetUtils;
import com.appslandia.common.utils.DateUtils;
import com.appslandia.common.utils.StringUtils;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Normalizer;
import javax.crypto.Cipher;

public class SecureConfig
extends PropertyConfig {
    private static final long serialVersionUID = 1L;
    final TextEncryptor textEncryptor;
    private static final String ENC_BEGIN = "ENC(";
    private static final String ENC_END = ")";

    public SecureConfig() {
        char[] pw = CryptoUtils.toCharArray(Cipher.class.getName().getBytes(CharsetUtils.ISO_8859_1));
        char[] np = Normalizer.normalize(new String(pw), Normalizer.Form.NFC).toCharArray();
        try {
            this.textEncryptor = new TextEncryptor(new PbeEncryptor().setTransformation("AES/CBC/PKCS5Padding").setKeySize(16).setPassword(np));
        }
        finally {
            CryptoUtils.clear(np);
            CryptoUtils.clear(pw);
        }
    }

    public SecureConfig(char[] password) {
        this.textEncryptor = new TextEncryptor(new PbeEncryptor().setTransformation("AES/CBC/PKCS5Padding").setKeySize(16).setPassword(password));
    }

    public SecureConfig(Encryptor encryptor) {
        this.textEncryptor = new TextEncryptor(encryptor);
    }

    public SecureConfig(TextEncryptor textEncryptor) {
        this.textEncryptor = textEncryptor;
    }

    @Override
    public String getString(String key) throws CryptoException {
        String value = super.getString(key);
        if (value == null) {
            return null;
        }
        if (!SecureConfig.isEncryptedValue(value)) {
            return value;
        }
        return this.textEncryptor.decrypt(SecureConfig.parseEncryptedValue(value));
    }

    protected void encrypt(String key, String value) throws CryptoException {
        this.props.put(key, value != null ? SecureConfig.markEncryptedValue(this.textEncryptor.encrypt(value)) : null);
    }

    public void sput(String key, String value) throws CryptoException {
        this.encrypt(key, StringUtils.trimToNull(value));
    }

    public void sput(String key, boolean value) throws CryptoException {
        this.encrypt(key, Boolean.toString(value));
    }

    public void sput(String key, int value) throws CryptoException {
        this.encrypt(key, Integer.toString(value));
    }

    public void sput(String key, long value) throws CryptoException {
        this.encrypt(key, Long.toString(value));
    }

    public void sput(String key, float value) throws CryptoException {
        this.encrypt(key, Float.toString(value));
    }

    public void sput(String key, double value) throws CryptoException {
        this.encrypt(key, Double.toString(value));
    }

    public void sput(String key, Boolean value) throws CryptoException {
        this.encrypt(key, value != null ? value.toString() : null);
    }

    public void sput(String key, Integer value) throws CryptoException {
        this.encrypt(key, value != null ? value.toString() : null);
    }

    public void sput(String key, Long value) throws CryptoException {
        this.encrypt(key, value != null ? value.toString() : null);
    }

    public void sput(String key, Float value) throws CryptoException {
        this.encrypt(key, value != null ? value.toString() : null);
    }

    public void sput(String key, Double value) throws CryptoException {
        this.encrypt(key, value != null ? value.toString() : null);
    }

    public void sput(String key, Date value) throws CryptoException {
        this.encrypt(key, value != null ? DateUtils.iso8601Date(value) : null);
    }

    public void sput(String key, Time value) throws CryptoException {
        this.encrypt(key, value != null ? DateUtils.iso8601Time(value) : null);
    }

    public void sput(String key, Timestamp value) throws CryptoException {
        this.encrypt(key, value != null ? DateUtils.iso8601DateTime(value) : null);
    }

    private static String markEncryptedValue(String value) {
        return ENC_BEGIN + value + ENC_END;
    }

    private static boolean isEncryptedValue(String value) {
        return value.startsWith(ENC_BEGIN) && value.endsWith(ENC_END);
    }

    private static String parseEncryptedValue(String value) {
        return value.substring(ENC_BEGIN.length(), value.length() - ENC_END.length());
    }
}

