/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.Permutation;
import com.appslandia.common.base.WordsGenerator;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharUtils;
import com.appslandia.common.utils.RandomUtils;
import java.security.SecureRandom;
import java.util.Random;
import java.util.regex.Pattern;

public class PasswordGenerator {
    public static final Pattern PASSWORD_PATTERN = Pattern.compile("(?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[$@&#!?*%:+-]).{8,32}");
    private static final char[] SYMBOLS = "$@&#!?*%:+-".toCharArray();
    private static final char[] UPPER_CASES = CharUtils.toCharRanges("A-Z");
    private static final char[] LOWER_CASES = CharUtils.toCharRanges("a-z");
    private static final char[] DIGITS = CharUtils.toCharRanges("0-9");
    final Random random = new SecureRandom();

    public char[] generatePassword(int minLength, int maxLength) {
        AssertUtils.assertTrue(minLength <= maxLength, "minLength <= maxLength");
        AssertUtils.assertTrue(minLength >= 8, "minLength >= 8");
        AssertUtils.assertTrue(maxLength <= 32, "maxLength <= 32");
        int length = RandomUtils.nextInt(this.random, minLength, maxLength);
        char[] pwdChars = new char[length];
        int emptyCount = length;
        Permutation sourceIndexes = new Permutation(4);
        block10: while (sourceIndexes.hasNext()) {
            switch (sourceIndexes.next()) {
                case 0: {
                    emptyCount = WordsGenerator.randomChars(this.random, UPPER_CASES, pwdChars, 1, emptyCount);
                    continue block10;
                }
                case 1: {
                    emptyCount = WordsGenerator.randomChars(this.random, LOWER_CASES, pwdChars, 1, emptyCount);
                    continue block10;
                }
                case 2: {
                    emptyCount = WordsGenerator.randomChars(this.random, DIGITS, pwdChars, 1, emptyCount);
                    continue block10;
                }
            }
            emptyCount = WordsGenerator.randomChars(this.random, SYMBOLS, pwdChars, 1, emptyCount);
        }
        block11: for (int i = 0; i < length; ++i) {
            if (pwdChars[i] != '\u0000') continue;
            int src = this.random.nextInt(4);
            switch (src) {
                case 0: {
                    pwdChars[i] = UPPER_CASES[this.random.nextInt(UPPER_CASES.length)];
                    continue block11;
                }
                case 1: {
                    pwdChars[i] = LOWER_CASES[this.random.nextInt(LOWER_CASES.length)];
                    continue block11;
                }
                case 2: {
                    pwdChars[i] = DIGITS[this.random.nextInt(DIGITS.length)];
                    continue block11;
                }
                default: {
                    pwdChars[i] = SYMBOLS[this.random.nextInt(SYMBOLS.length)];
                }
            }
        }
        return pwdChars;
    }

    public boolean verifyPassword(String password) {
        AssertUtils.assertNotNull(password);
        return PASSWORD_PATTERN.matcher(password).matches();
    }
}

