/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.crypto.PasswordGenerator;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public class CryptoUtils {
    public static void clear(char[] chars) {
        Arrays.fill(chars, '0');
    }

    public static void clear(byte[] bytes) {
        Arrays.fill(bytes, (byte)0);
    }

    public static char[] toCharArray(byte[] src) {
        char[] arr = new char[src.length / 2];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (char)((0xFF & src[i * 2]) << 8 | 0xFF & src[i * 2 + 1]);
        }
        return arr;
    }

    public static byte[] toByteArray(char[] src) {
        byte[] arr = new byte[src.length * 2];
        for (int i = 0; i < src.length; ++i) {
            char chr = src[i];
            arr[i * 2] = (byte)(0xFF & chr >> 8);
            arr[i * 2 + 1] = (byte)(0xFF & chr);
        }
        return arr;
    }

    public static void tryDestroy(Object destroyable) {
        if (!(destroyable instanceof Destroyable)) {
            return;
        }
        Destroyable obj = (Destroyable)destroyable;
        if (!obj.isDestroyed()) {
            try {
                obj.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                // empty catch block
            }
        }
    }

    public static char[] generatePassword(int length) {
        return new PasswordGenerator().generatePassword(length, length);
    }
}

