/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.cdi;

import com.appslandia.common.base.DeployPhase;
import com.appslandia.common.base.EnablePhases;
import com.appslandia.common.cdi.CDIFactory;
import com.appslandia.common.cdi.CDIUtils;
import com.appslandia.common.utils.CollectionUtils;
import com.appslandia.common.utils.ObjectUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;

public class CDIVetoExtension
implements Extension {
    final Set<Class<?>> vetoedClasses = new HashSet();
    final Set<String> vetoedPackages = new HashSet<String>();
    final Set<Class<? extends Annotation>> vetoedAnnotations = new HashSet<Class<? extends Annotation>>();

    protected void vetoClasses(Class<?> ... beanClasses) {
        CollectionUtils.add(this.vetoedClasses, beanClasses);
    }

    protected void vetoPackages(String ... packages) {
        CollectionUtils.add(this.vetoedPackages, packages);
    }

    protected void vetoPackages(Class<?> ... beanClasses) {
        for (Class<?> clazz : beanClasses) {
            this.vetoedPackages.add(clazz.getPackage().getName());
        }
    }

    protected void vetoAnnotations(Class<?> ... annotationClasses) {
        for (Class<?> clazz : annotationClasses) {
            this.vetoedAnnotations.add((Class<? extends Annotation>)ObjectUtils.cast(clazz));
        }
    }

    protected boolean willVetoClass(Class<?> beanClass) {
        return false;
    }

    protected void onVetoClass(Class<?> beanClass) {
    }

    protected void onDeployClass(Class<?> beanClass) {
    }

    public <T> void processAnotated(@Observes ProcessAnnotatedType<T> event) {
        Class beanClass = event.getAnnotatedType().getJavaClass();
        if (CDIVetoExtension.willVetoClasses(this.vetoedClasses, beanClass)) {
            event.veto();
            this.onVetoClass(beanClass);
            return;
        }
        if (CDIVetoExtension.willVetoPackages(this.vetoedPackages, beanClass)) {
            event.veto();
            this.onVetoClass(beanClass);
            return;
        }
        if (CDIVetoExtension.willVetoAnnotations(this.vetoedAnnotations, beanClass)) {
            event.veto();
            this.onVetoClass(beanClass);
            return;
        }
        EnablePhases enablePhases = CDIVetoExtension.getEnablePhases(beanClass);
        if (enablePhases != null && !DeployPhase.getCurrent().isAny(enablePhases.value())) {
            event.veto();
            this.onVetoClass(beanClass);
            return;
        }
        if (this.willVetoClass(beanClass)) {
            event.veto();
            this.onVetoClass(beanClass);
            return;
        }
        this.onDeployClass(beanClass);
    }

    public static boolean willVetoClasses(Set<Class<?>> vetoedClasses, Class<?> beanClass) {
        Method factoryMethod;
        if (vetoedClasses.isEmpty()) {
            return false;
        }
        if (vetoedClasses.contains(beanClass)) {
            return true;
        }
        return CDIFactory.class.isAssignableFrom(beanClass) && vetoedClasses.contains((factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(beanClass))).getReturnType());
    }

    public static boolean willVetoPackages(Set<String> vetoedPackages, Class<?> beanClass) {
        if (vetoedPackages.isEmpty()) {
            return false;
        }
        for (String pkg : vetoedPackages) {
            if (!beanClass.getPackage().getName().equals(pkg)) continue;
            return true;
        }
        if (CDIFactory.class.isAssignableFrom(beanClass)) {
            Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(beanClass));
            for (String pkg : vetoedPackages) {
                if (!factoryMethod.getReturnType().getPackage().getName().equals(pkg)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean willVetoAnnotations(Set<Class<? extends Annotation>> vetoedAnnotations, Class<?> beanClass) {
        if (vetoedAnnotations.isEmpty()) {
            return false;
        }
        for (Class<? extends Annotation> annotationClass : vetoedAnnotations) {
            if (beanClass.getDeclaredAnnotation(annotationClass) == null) continue;
            return true;
        }
        if (CDIFactory.class.isAssignableFrom(beanClass)) {
            Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(beanClass));
            for (Class<? extends Annotation> annotationClass : vetoedAnnotations) {
                if (factoryMethod.getDeclaredAnnotation(annotationClass) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static EnablePhases getEnablePhases(Class<?> beanClass) {
        EnablePhases enablePhases = beanClass.getDeclaredAnnotation(EnablePhases.class);
        if (enablePhases != null) {
            return enablePhases;
        }
        if (CDIFactory.class.isAssignableFrom(beanClass)) {
            Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(beanClass));
            return factoryMethod.getDeclaredAnnotation(EnablePhases.class);
        }
        return null;
    }
}

