/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.cdi;

import com.appslandia.common.cdi.CDIFactory;
import com.appslandia.common.cdi.CDISupplier;
import com.appslandia.common.cdi.Supplier;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ReflectionException;
import com.appslandia.common.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;

public class CDIUtils {
    public static <T> T getReference(BeanManager beanManager, Class<? extends T> type) {
        return CDIUtils.getReference(beanManager, type, ReflectionUtils.EMPTY_ANNOTATIONS);
    }

    public static <T> T getReference(BeanManager beanManager, Class<? extends T> type, Annotation ... qualifiers) {
        Set matchedBeans = beanManager.getBeans(type, qualifiers);
        if (matchedBeans.isEmpty()) {
            return null;
        }
        Bean bean = beanManager.resolve(matchedBeans);
        if (bean == null) {
            return null;
        }
        return ObjectUtils.cast(beanManager.getReference(bean, type, beanManager.createCreationalContext((Contextual)bean)));
    }

    public static <T> T getReference(BeanManager beanManager, String name) {
        Set matchedBeans = beanManager.getBeans(name);
        if (matchedBeans.isEmpty()) {
            return null;
        }
        Bean bean = beanManager.resolve(matchedBeans);
        if (bean == null) {
            return null;
        }
        return ObjectUtils.cast(beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext((Contextual)bean)));
    }

    public static <T> T getInstance(BeanManager beanManager, Class<? extends T> type) {
        return CDIUtils.getInstance(beanManager, type, ReflectionUtils.EMPTY_ANNOTATIONS);
    }

    public static <T> T getInstance(BeanManager beanManager, Class<? extends T> type, Annotation ... qualifiers) {
        Set matchedBeans = beanManager.getBeans(type, qualifiers);
        if (matchedBeans.isEmpty()) {
            return null;
        }
        Bean bean = (Bean)ObjectUtils.cast(beanManager.resolve(matchedBeans));
        if (bean == null) {
            return null;
        }
        return (T)beanManager.getContext(bean.getScope()).get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
    }

    public static <T> T getInstance(BeanManager beanManager, String name) {
        Set matchedBeans = beanManager.getBeans(name);
        if (matchedBeans.isEmpty()) {
            return null;
        }
        Bean bean = (Bean)ObjectUtils.cast(beanManager.resolve(matchedBeans));
        if (bean == null) {
            return null;
        }
        return (T)beanManager.getContext(bean.getScope()).get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
    }

    public static <T, A extends Annotation> void scanBeanInstances(BeanManager beanManager, Class<T> type, Annotation[] qualifiers, Class<A> annotationClass, BiConsumer<A, T> consumer) {
        Set beans = (Set)ObjectUtils.cast(beanManager.getBeans(type, qualifiers));
        for (Bean bean : beans) {
            if (annotationClass == null) {
                Object impl = beanManager.getContext(bean.getScope()).get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
                consumer.accept(null, impl);
                continue;
            }
            A annotation = bean.getBeanClass().getDeclaredAnnotation(annotationClass);
            if (annotation == null && CDIFactory.class.isAssignableFrom(bean.getBeanClass())) {
                Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(bean.getBeanClass()));
                annotation = factoryMethod.getDeclaredAnnotation(annotationClass);
            }
            if (annotation == null) continue;
            Object impl = beanManager.getContext(bean.getScope()).get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
            consumer.accept(annotation, impl);
        }
    }

    public static void scanSupplierInstances(BeanManager beanManager, Annotation[] qualifiers, Class<?> constraintType, Consumer<CDISupplier> consumer) {
        Set beans = (Set)ObjectUtils.cast(beanManager.getBeans(CDISupplier.class, qualifiers));
        for (Bean bean : beans) {
            Supplier supplier = bean.getBeanClass().getDeclaredAnnotation(Supplier.class);
            if (supplier == null && CDIFactory.class.isAssignableFrom(bean.getBeanClass())) {
                Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(bean.getBeanClass()));
                supplier = factoryMethod.getDeclaredAnnotation(Supplier.class);
            }
            if (supplier == null || supplier.value() != constraintType) continue;
            CDISupplier impl = (CDISupplier)beanManager.getContext(bean.getScope()).get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
            consumer.accept(impl);
        }
    }

    public static <T, A extends Annotation> void scanBeanClasses(BeanManager beanManager, Class<T> type, Annotation[] qualifiers, Class<A> annotationClass, BiConsumer<A, Class<?>> consumer) {
        Set beans = (Set)ObjectUtils.cast(beanManager.getBeans(type, qualifiers));
        for (Bean bean : beans) {
            A annotation = bean.getBeanClass().getDeclaredAnnotation(annotationClass);
            if (annotation == null && CDIFactory.class.isAssignableFrom(bean.getBeanClass())) {
                Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(bean.getBeanClass()));
                annotation = factoryMethod.getDeclaredAnnotation(annotationClass);
            }
            if (annotation == null) continue;
            consumer.accept(annotation, bean.getBeanClass());
        }
    }

    public static Method getFactoryMethod(Class<? extends CDIFactory<?>> factoryClass) {
        try {
            return factoryClass.getMethod("produce", new Class[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Annotation getImpl(Class<? extends Annotation> qualifier) {
        try {
            Field impl = qualifier.getDeclaredField("IMPL");
            AssertUtils.assertTrue(ReflectionUtils.isPublicStaticFinal(impl.getModifiers()));
            return (Annotation)impl.get(null);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException(ex);
        }
    }
}

