/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.InitializeException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.JsonException;
import com.appslandia.common.base.StringWriter;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ReflectionUtils;
import java.io.Reader;
import java.io.Writer;

public abstract class JsonProcessor
extends InitializeObject {
    private static JsonProcessor instance;
    private static final Object MUTEX;

    public abstract void write(Writer var1, Object var2) throws JsonException;

    public abstract <T> T read(Reader var1, Class<? extends T> var2) throws JsonException;

    public abstract JsonProcessor copy();

    public String toString(Object obj) throws JsonException {
        StringWriter out = new StringWriter();
        this.write(out, obj);
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonProcessor getInstance() {
        JsonProcessor obj = instance;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = instance;
                if (obj == null) {
                    instance = obj = JsonProcessor.initJsonProcessor();
                }
            }
        }
        return obj;
    }

    public static void setInstance(JsonProcessor instance) {
        AssertUtils.assertNull(JsonProcessor.instance);
        JsonProcessor.instance = instance;
    }

    private static JsonProcessor initJsonProcessor() {
        try {
            Class implClass = ReflectionUtils.loadClass("com.appslandia.common.gson.GsonProcessor", null);
            return (JsonProcessor)implClass.newInstance();
        }
        catch (Exception ex) {
            throw new InitializeException(ex);
        }
    }

    static {
        MUTEX = new Object();
    }
}

