/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.base.Language;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class FormatProviderImpl
implements FormatProvider {
    protected final Language language;
    protected Map<String, SimpleDateFormat> dateFormatCache;
    protected NumberFormat integerFormat;
    protected NumberFormat numberFormat;
    protected NumberFormat bigDecimalFormat;

    public FormatProviderImpl() {
        this(Language.getCurrent());
    }

    public FormatProviderImpl(Language language) {
        this.language = language;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public NumberFormat getIntegerFormat() {
        if (this.integerFormat == null) {
            this.integerFormat = NumberFormat.getIntegerInstance(this.language.getLocale());
        }
        return this.integerFormat;
    }

    @Override
    public NumberFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getNumberInstance(this.language.getLocale());
        }
        return this.numberFormat;
    }

    @Override
    public NumberFormat getBigDecimalFormat() {
        if (this.bigDecimalFormat == null) {
            NumberFormat format = NumberFormat.getNumberInstance(this.language.getLocale());
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setParseBigDecimal(true);
            }
            this.bigDecimalFormat = format;
        }
        return this.bigDecimalFormat;
    }

    @Override
    public DateFormat getDateFormat() {
        return this.getDateFormatCache().get(this.language.getDateFormat());
    }

    @Override
    public DateFormat getTimeFormat() {
        return this.getDateFormatCache().get(this.language.getTimeFormat());
    }

    @Override
    public DateFormat getDateTimeFormat() {
        return this.getDateFormatCache().get(this.language.getDateTimeFormat());
    }

    @Override
    public DateFormat getTimeFormat24H() {
        return this.getDateFormatCache().get(this.language.getTimeFormat24H());
    }

    @Override
    public DateFormat getDateTimeFormat24H() {
        return this.getDateFormatCache().get(this.language.getDateTimeFormat24H());
    }

    protected Map<String, SimpleDateFormat> getDateFormatCache() {
        if (this.dateFormatCache == null) {
            this.dateFormatCache = new HashMap<String, SimpleDateFormat>(7){
                private static final long serialVersionUID = 1L;

                @Override
                public SimpleDateFormat get(Object pattern) {
                    SimpleDateFormat obj = (SimpleDateFormat)super.get(pattern);
                    if (obj == null) {
                        obj = new SimpleDateFormat((String)pattern);
                        obj.setLenient(false);
                        this.put((String)pattern, obj);
                    }
                    return obj;
                }
            };
        }
        return this.dateFormatCache;
    }
}

