/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.BoolFormatException;
import com.appslandia.common.base.Config;
import com.appslandia.common.base.DateFormatException;
import com.appslandia.common.base.MapAccessor;
import com.appslandia.common.utils.DateUtils;
import com.appslandia.common.utils.SplitUtils;
import com.appslandia.common.utils.StringFormatUtils;
import com.appslandia.common.utils.StringUtils;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

public abstract class ConfigBase
implements Config,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, String> props;
    final transient Map<String, Object> mapAccessor = new MapAccessor<String, Object>(){

        @Override
        public Object get(Object key) {
            return ConfigBase.this.getString((String)key);
        }
    };

    public ConfigBase(Map<String, String> newMap) {
        this.props = newMap;
    }

    @Override
    public String getString(String key) {
        return this.props.get(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public String getRequiredString(String key) throws NullPointerException {
        String value = this.getString(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return value;
    }

    @Override
    public String[] getStringArray(String key) {
        String value = this.getString(key);
        if (value == null) {
            return StringUtils.EMPTY_ARRAY;
        }
        List<String> list = SplitUtils.splitByComma(value);
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String getFormatted(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return StringFormatUtils.format(value, this.mapAccessor);
    }

    @Override
    public String getRequiredFormatted(String key) throws NullPointerException {
        String value = this.getString(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return StringFormatUtils.format(value, this.mapAccessor);
    }

    @Override
    public String getFormatted(String key, Map<String, Object> parameters) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return StringFormatUtils.format(value, parameters);
    }

    @Override
    public String getRequiredFormatted(String key, Map<String, Object> parameters) throws NullPointerException {
        String value = this.getString(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return StringFormatUtils.format(value, parameters);
    }

    @Override
    public String getFormatted(String key, Object ... parameters) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return StringFormatUtils.format(value, parameters);
    }

    @Override
    public String getRequiredFormatted(String key, Object ... parameters) throws NullPointerException {
        String value = this.getString(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return StringFormatUtils.format(value, parameters);
    }

    @Override
    public boolean getBool(String key, boolean defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        if (ConfigBase.isTrueValue(value)) {
            return true;
        }
        if (ConfigBase.isFalseValue(value)) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public boolean getRequiredBool(String key) throws NullPointerException, BoolFormatException {
        String value = this.getString(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        if (ConfigBase.isTrueValue(value)) {
            return true;
        }
        if (ConfigBase.isFalseValue(value)) {
            return false;
        }
        throw new BoolFormatException(value);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public int getRequiredInt(String key) throws NullPointerException, NumberFormatException {
        String value = this.getString(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return Integer.parseInt(value);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public long getRequiredLong(String key) throws NullPointerException, NumberFormatException {
        String value = this.getString(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return Long.parseLong(value);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public float getRequiredFloat(String key) throws NullPointerException, NumberFormatException {
        String value = this.getString(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return Float.parseFloat(value);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    @Override
    public double getRequiredDouble(String key) throws NullPointerException, NumberFormatException {
        String value = this.getString(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return Double.parseDouble(value);
    }

    @Override
    public Date getDate(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        try {
            return DateUtils.iso8601Date(value);
        }
        catch (DateFormatException ex) {
            return null;
        }
    }

    @Override
    public Date getRequiredDate(String key) throws NullPointerException, DateFormatException {
        String value = this.getString(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return DateUtils.iso8601Date(value);
    }

    @Override
    public Time getTime(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        try {
            return DateUtils.iso8601Time(value);
        }
        catch (DateFormatException ex) {
            return null;
        }
    }

    @Override
    public Time getRequiredTime(String key) throws NullPointerException, DateFormatException {
        String value = this.getString(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return DateUtils.iso8601Time(value);
    }

    @Override
    public Timestamp getDateTime(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        try {
            return DateUtils.iso8601DateTime(value);
        }
        catch (DateFormatException ex) {
            return null;
        }
    }

    @Override
    public Timestamp getRequiredDateTime(String key) throws NullPointerException, DateFormatException {
        String value = this.getString(key);
        if (value == null) {
            throw new NullPointerException("key=" + key);
        }
        return DateUtils.iso8601DateTime(value);
    }

    public Iterable<String> getKeys() {
        return this.props.keySet();
    }

    public ConfigBase put(String key, String value) {
        this.props.put(key, StringUtils.trimToNull(value));
        return this;
    }

    public ConfigBase put(String key, boolean value) {
        this.props.put(key, Boolean.toString(value));
        return this;
    }

    public ConfigBase put(String key, int value) {
        this.props.put(key, Integer.toString(value));
        return this;
    }

    public ConfigBase put(String key, long value) {
        this.props.put(key, Long.toString(value));
        return this;
    }

    public ConfigBase put(String key, float value) {
        this.props.put(key, Float.toString(value));
        return this;
    }

    public ConfigBase put(String key, double value) {
        this.props.put(key, Double.toString(value));
        return this;
    }

    public ConfigBase put(String key, Boolean value) {
        this.props.put(key, value != null ? value.toString() : null);
        return this;
    }

    public ConfigBase put(String key, Integer value) {
        this.props.put(key, value != null ? value.toString() : null);
        return this;
    }

    public ConfigBase put(String key, Long value) {
        this.props.put(key, value != null ? value.toString() : null);
        return this;
    }

    public ConfigBase put(String key, Float value) {
        this.props.put(key, value != null ? value.toString() : null);
        return this;
    }

    public ConfigBase put(String key, Double value) {
        this.props.put(key, value != null ? value.toString() : null);
        return this;
    }

    public ConfigBase put(String key, Date value) {
        this.props.put(key, value != null ? DateUtils.iso8601Date(value) : null);
        return this;
    }

    public ConfigBase put(String key, Time value) {
        this.props.put(key, value != null ? DateUtils.iso8601Time(value) : null);
        return this;
    }

    public ConfigBase put(String key, Timestamp value) {
        this.props.put(key, value != null ? DateUtils.iso8601DateTime(value) : null);
        return this;
    }

    static boolean isTrueValue(String value) {
        return value.equalsIgnoreCase(Boolean.TRUE.toString()) || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on");
    }

    static boolean isFalseValue(String value) {
        return value.equalsIgnoreCase(Boolean.FALSE.toString()) || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("off");
    }
}

