// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;

/**
 *
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 *
 */
public class FileUtils {

	public static String insertNow(String fileName) {
		String now = DateUtils.format(new Date(), "yyyyMMdd-HHmmss");
		int idx = fileName.lastIndexOf('.');
		if (idx < 0) {
			return fileName + "-" + now;
		}
		if (idx == 0) {
			return now + fileName;
		}
		return fileName.substring(0, idx) + "-" + now + fileName.substring(idx);
	}

	public static String insertExtra(String fileName, String extra) {
		int idx = fileName.lastIndexOf('.');
		if (idx < 0) {
			return fileName + extra;
		}
		if (idx == 0) {
			return extra + fileName;
		}
		return fileName.substring(0, idx) + extra + fileName.substring(idx);
	}

	public static void copy(File src, File dest) throws IOException {
		FileInputStream fis = null;
		FileOutputStream fos = null;
		try {
			fis = new FileInputStream(src);
			fos = new FileOutputStream(dest);

			IOUtils.copy(fis, fos);
		} finally {
			if (fos != null) {
				fos.close();
			}
			if (fis != null) {
				fis.close();
			}
		}
	}

	public static byte[] readAllBytes(File src) throws IOException {
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(src);
			return IOUtils.toByteArray(fis);
		} finally {
			if (fis != null) {
				fis.close();
			}
		}
	}
}
