// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.utils;

/**
 * 
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 */
public class ContentTypes {

	public static final String TEXT_PLAIN = "text/plain";
	public static final String TEXT_HTML = "text/html";

	public static final String APP_JSON = "application/json";
	public static final String APP_XML = "application/xml";

	public static final String APP_CSV = "application/csv";
	public static final String APP_PDF = "application/pdf";

	public static final String APP_XLS = "application/vnd.ms-excel";
	public static final String APP_XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";

	public static final String APP_DOC = "application/msword";
	public static final String APP_DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";

	public static final String APP_PPT = "application/vnd.ms-powerpoint";
	public static final String APP_PPTX = "application/vnd.openxmlformats-officedocument.presentationml.presentation";

	public static final String IMAGE_PNG = "image/png";
	public static final String IMAGE_JPEG = "image/jpeg";
	public static final String IMAGE_GIF = "image/gif";
	public static final String IMAGE_BMP = "image/bmp";

	public static final String APP_OCTET_STREAM = "application/octet-stream";
	public static final String MULTIPART_FORM_DATA = "multipart/form-data";
	public static final String APP_FORM_URLENCODED = "application/x-www-form-urlencoded";
}
