// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.base;

import java.util.LinkedHashMap;
import java.util.Map;

import com.appslandia.common.utils.URLEncoding;

/**
 *
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 *
 */
public class QueryParams extends ConfigBase {
	private static final long serialVersionUID = 1L;

	public QueryParams() {
		super(new LinkedHashMap<>());
	}

	public QueryParams(Map<String, String> newMap) {
		super(newMap);
	}

	public QueryParams parse(String queryString) {
		int startIdx = 0;
		int endIdx;
		while ((endIdx = queryString.indexOf('&', startIdx)) != -1) {
			parseNameVal(queryString.substring(startIdx, endIdx));
			startIdx = endIdx + 1;
		}
		if (startIdx < queryString.length()) {
			parseNameVal(queryString.substring(startIdx));
		}
		return this;
	}

	private void parseNameVal(String nameVal) {
		int idx = nameVal.indexOf('=');
		if (idx <= 0) {
			return;
		}
		String name = nameVal.substring(0, idx).trim();
		if (name.isEmpty()) {
			return;
		}
		String value = nameVal.substring(idx + 1).trim();
		if (value.isEmpty()) {
			this.props.put(name, null);
		} else {
			this.props.put(name, URLEncoding.decode(value));
		}
	}

	@Override
	public String toString() {
		if (this.props.isEmpty()) {
			return null;
		}
		return toBuilder().toString();
	}

	public StringBuilder toBuilder() {
		StringBuilder sb = new StringBuilder();
		for (Map.Entry<String, String> entry : this.props.entrySet()) {
			if (sb.length() > 0) {
				sb.append('&');
			}
			sb.append(entry.getKey()).append('=');
			if (entry.getValue() != null) {
				sb.append(URLEncoding.encode(entry.getValue()));
			}
		}
		return sb;
	}

	public QueryParams put(String key, String value) {
		return (QueryParams) super.put(key, value);
	}

	public QueryParams put(String key, boolean value) {
		return (QueryParams) super.put(key, value);
	}

	public QueryParams put(String key, int value) {
		return (QueryParams) super.put(key, value);
	}

	public QueryParams put(String key, long value) {
		return (QueryParams) super.put(key, value);
	}

	public QueryParams put(String key, float value) {
		return (QueryParams) super.put(key, value);
	}

	public QueryParams put(String key, double value) {
		return (QueryParams) super.put(key, value);
	}

	public QueryParams put(String key, Boolean value) {
		return (QueryParams) super.put(key, value);
	}

	public QueryParams put(String key, Integer value) {
		return (QueryParams) super.put(key, value);
	}

	public QueryParams put(String key, Long value) {
		return (QueryParams) super.put(key, value);
	}

	public QueryParams put(String key, Float value) {
		return (QueryParams) super.put(key, value);
	}

	public QueryParams put(String key, Double value) {
		return (QueryParams) super.put(key, value);
	}

	public QueryParams put(String key, java.sql.Date value) {
		return (QueryParams) super.put(key, value);
	}

	public QueryParams put(String key, java.sql.Time value) {
		return (QueryParams) super.put(key, value);
	}

	public QueryParams put(String key, java.sql.Timestamp value) {
		return (QueryParams) super.put(key, value);
	}
}
