// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.base;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ReflectionUtils;

/**
 * 
 * 
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 *
 */
public class Base64 {

	private static volatile Delegate delegate;
	private static final Object MUTEX = new Object();

	private Base64() {
	}

	public static Base64.Delegate getDelegate() {
		Delegate obj = delegate;
		if (obj == null) {
			synchronized (MUTEX) {
				if ((obj = delegate) == null) {
					delegate = obj = initJdk8Delegate();
				}
			}
		}
		return obj;
	}

	private static Base64.Delegate initJdk8Delegate() {
		try {
			Class<? extends Base64.Delegate> implClass = ReflectionUtils.loadClass("com.appslandia.common.base.Jdk8Base64Delegate", null);
			return implClass.newInstance();
		} catch (Exception ex) {
			throw new InitializeException(ex);
		}
	}

	public static void setDelegate(Base64.Delegate obj) {
		AssertUtils.assertNull(delegate);
		delegate = obj;
	}

	public interface Delegate {

		byte[] encode(byte[] src);

		byte[] decode(byte[] src);

		byte[] urlEncode(byte[] src);

		byte[] urlDecode(byte[] src);

		byte[] mimeEncode(byte[] src);

		byte[] mimeDecode(byte[] src);
	}
}
