/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.URLEncoding;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class URLUtils {
    public static String toQueryParams(Map<String, Object> parameterMap) {
        AssertUtils.assertNotNull(parameterMap);
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, Object> param : parameterMap.entrySet()) {
            if (queryString.length() > 0) {
                queryString.append('&');
            }
            queryString.append(param.getKey()).append('=');
            if (param.getValue() == null) continue;
            queryString.append(URLEncoding.encode(param.getValue().toString()));
        }
        return queryString.toString();
    }

    public static String toURL(String url, Map<String, Object> parameterMap) {
        AssertUtils.assertNotNull(parameterMap);
        try {
            URI oldUri = new URI(url);
            String newQuery = oldUri.getQuery();
            newQuery = newQuery == null ? URLUtils.toQueryParams(parameterMap) : newQuery + "&" + URLUtils.toQueryParams(parameterMap);
            URI newUri = new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), newQuery, oldUri.getFragment());
            return newUri.toString();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

