/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.ReflectionException;
import com.appslandia.common.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectionUtils {
    public static final Object[] EMPTY_OBJECTS = new Object[0];
    public static final Class<?>[] EMPTY_CLASSES = new Class[0];
    public static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    public static final FieldTraverser FIND_FIELD_TRAVERSER = new FieldTraverser(){

        @Override
        public boolean apply(Field field) throws ReflectionException {
            return true;
        }
    };
    public static final MethodTraverser FIND_METHOD_TRAVERSER = new MethodTraverser(){

        @Override
        public boolean apply(Method m) throws ReflectionException {
            return true;
        }
    };

    public static Field findField(Class<?> clazz, final String property) throws ReflectionException {
        return ReflectionUtils.traverse(clazz, new FieldMatcher(){

            @Override
            public boolean match(Field f) {
                if (f.getName().equals(property)) {
                    return true;
                }
                return f.getType() == Boolean.TYPE && f.getName().equals("is" + StringUtils.firstUpperCase(property));
            }
        }, FIND_FIELD_TRAVERSER);
    }

    public static Method findMethod(Class<?> clazz, final String methodName) throws ReflectionException {
        return ReflectionUtils.traverse(clazz, new MethodMatcher(){

            @Override
            public boolean match(Method m) {
                return m.getName().equals(methodName);
            }
        }, FIND_METHOD_TRAVERSER);
    }

    public static Field traverse(Class<?> clazz, FieldMatcher matcher, FieldTraverser traverser) throws ReflectionException {
        Field last = null;
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!matcher.match(field)) continue;
                last = field;
                if (!traverser.apply(field)) continue;
                return last;
            }
            clazz = clazz.getSuperclass();
        }
        return last;
    }

    public static Method traverse(Class<?> clazz, MethodMatcher matcher, MethodTraverser traverser) throws ReflectionException {
        Method last = null;
        while (clazz != null) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!matcher.match(m)) continue;
                last = m;
                if (!traverser.apply(m)) continue;
                return last;
            }
            clazz = clazz.getSuperclass();
        }
        return last;
    }

    public static Object invoke(Method m, Object obj, Object ... args) throws ReflectionException {
        try {
            return m.invoke(obj, args);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static void set(Field m, Object obj, Object value) throws ReflectionException {
        try {
            m.set(obj, value);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Object get(Field m, Object obj) throws ReflectionException {
        try {
            return m.get(obj);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz) {
        return ReflectionUtils.getConstructor(clazz, EMPTY_CLASSES);
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... paramTypes) {
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static boolean isPublicStaticFinal(int modifier) {
        return Modifier.isPublic(modifier) && Modifier.isStatic(modifier) && Modifier.isFinal(modifier);
    }

    public static interface MethodTraverser {
        public boolean apply(Method var1) throws ReflectionException;
    }

    public static interface MethodMatcher {
        public boolean match(Method var1);
    }

    public static interface FieldTraverser {
        public boolean apply(Field var1) throws ReflectionException;
    }

    public static interface FieldMatcher {
        public boolean match(Field var1);
    }
}

