/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.PatternUtils;
import java.text.Normalizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class NormalizeUtils {
    private static final Pattern STRIP_ACCENTS_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static final Map<Character, Character> STRIP_ACCENTS_MAP;
    private static final Pattern[] WHITESPACE_PUNCT_DOUBLE_HYPHEN_PATTERNS;
    private static final Pattern[] DOUBLE_WHITESPACES_PATTERNS;

    public static String unaccent(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(Normalizer.normalize(text, Normalizer.Form.NFD));
        for (int i = 0; i < sb.length(); ++i) {
            Character chr = STRIP_ACCENTS_MAP.get(Character.valueOf(text.charAt(i)));
            if (chr == null) continue;
            sb.setCharAt(i, chr.charValue());
        }
        return STRIP_ACCENTS_PATTERN.matcher(sb).replaceAll("");
    }

    public static String toLabel(String text) {
        return NormalizeUtils.normalize(text, WHITESPACE_PUNCT_DOUBLE_HYPHEN_PATTERNS, '-');
    }

    public static String toText(String text) {
        return NormalizeUtils.normalize(text, DOUBLE_WHITESPACES_PATTERNS, ' ');
    }

    public static String normalize(String text, Pattern[] replacePatterns, char bySep) {
        if (text == null) {
            return null;
        }
        String replacement = new String(new char[]{bySep});
        for (Pattern p : replacePatterns) {
            text = p.matcher(text).replaceAll(replacement);
        }
        return !(text = NormalizeUtils.trim(text, bySep)).isEmpty() ? text : null;
    }

    private static String trim(String name, char charToTrim) {
        int start = -1;
        while (++start < name.length() && name.charAt(start) == charToTrim) {
        }
        int end = name.length();
        while (--end >= 0 && name.charAt(end) == charToTrim) {
        }
        if (start >= end) {
            return "";
        }
        return name.substring(start, end + 1);
    }

    static {
        HashMap<Character, Character> map = new HashMap<Character, Character>();
        map.put(Character.valueOf('\u0110'), Character.valueOf('D'));
        map.put(Character.valueOf('\u0111'), Character.valueOf('d'));
        map.put(Character.valueOf('\u0126'), Character.valueOf('H'));
        map.put(Character.valueOf('\u0127'), Character.valueOf('h'));
        map.put(Character.valueOf('\u0141'), Character.valueOf('L'));
        map.put(Character.valueOf('\u0142'), Character.valueOf('l'));
        map.put(Character.valueOf('\u0166'), Character.valueOf('T'));
        map.put(Character.valueOf('\u0167'), Character.valueOf('t'));
        STRIP_ACCENTS_MAP = Collections.unmodifiableMap(map);
        WHITESPACE_PUNCT_DOUBLE_HYPHEN_PATTERNS = PatternUtils.compile("\\s+|\\p{Punct}+", "-{2,}");
        DOUBLE_WHITESPACES_PATTERNS = PatternUtils.compile("\\s{2,}");
    }
}

