/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import java.math.BigInteger;

public class MathUtils {
    public static int ceil(int n, int base) {
        AssertUtils.assertTrue(n >= 0);
        AssertUtils.assertTrue(base > 0);
        return (n + base - 1) / base * base;
    }

    public static int pow2(int exponent) {
        return MathUtils.pow(2, exponent);
    }

    public static int pow(int n, int exponent) {
        AssertUtils.assertTrue(exponent >= 0);
        BigInteger pow = BigInteger.valueOf(n).pow(exponent);
        long val = pow.longValueExact();
        if (val < Integer.MIN_VALUE || val > Integer.MAX_VALUE) {
            throw new ArithmeticException();
        }
        return pow.intValue();
    }

    public static byte[] toByteArray(int value) {
        byte[] bytes = new byte[4];
        for (int i = 3; i >= 0; --i) {
            bytes[i] = (byte)(value & 0xFF);
            value >>= 8;
        }
        return bytes;
    }

    public static int toInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static byte[] toByteArray(long value) {
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return bytes;
    }

    public static long toLong(byte[] bytes) {
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }

    public static byte[] toByteArray(int begin, int end) {
        AssertUtils.assertTrue(begin <= end);
        AssertUtils.assertTrue(begin >= -128);
        AssertUtils.assertTrue(end <= 127);
        byte[] byteArray = new byte[end - begin + 1];
        for (int i = begin; i <= end; ++i) {
            byteArray[i - begin] = (byte)i;
        }
        return byteArray;
    }
}

