/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.CaseInsensitiveMap;
import com.appslandia.common.base.Config;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CLIUtils;
import com.appslandia.common.utils.SplitUtils;
import com.appslandia.common.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class ConsoleApp {
    final String title;
    final Map<String, CommandHandler> handlers = new CaseInsensitiveMap<CommandHandler>();

    public ConsoleApp(String title) {
        this.title = title;
    }

    public void registerCommand(String command, CommandHandler handler) {
        AssertUtils.assertTrue(!this.handlers.containsKey(command), "handler is already added.");
        this.handlers.put(command, handler);
    }

    public void run() {
        Scanner scanner = new Scanner(System.in);
        System.out.println(this.title);
        while (true) {
            System.out.print("> ");
            String input = StringUtils.trimToEmpty(scanner.nextLine());
            if (input.isEmpty()) continue;
            if ("x".equalsIgnoreCase(input)) break;
            List<String> items = SplitUtils.splitByWhitespace(input);
            String command = items.remove(0);
            String[] args = items.toArray(new String[items.size()]);
            CommandHandler handler = this.handlers.get(command);
            if (handler == null) {
                System.out.println(String.format("Command '%s' is required.", command));
                continue;
            }
            try {
                handler.handle(CLIUtils.parseArgs(args));
            }
            catch (Throwable ex) {
                ex.printStackTrace(System.out);
            }
        }
        scanner.close();
    }

    public static interface CommandHandler {
        public void handle(Config var1) throws Exception;
    }
}

