/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.objects;

import com.appslandia.common.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import javax.inject.Qualifier;

public class AnnotationUtils {
    public static boolean equals(Annotation[] annotations1, Annotation[] annotations2) {
        if (annotations1.length != annotations2.length) {
            return false;
        }
        for (Annotation annotation1 : annotations1) {
            Annotation annotation2;
            boolean matched = false;
            Annotation[] annotationArray = annotations2;
            int n = annotationArray.length;
            for (int i = 0; i < n && !(matched = annotation1.equals(annotation2 = annotationArray[i])); ++i) {
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public static Annotation[] parseQualifiers(Annotation[] annotations) {
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>(3);
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().getDeclaredAnnotation(Qualifier.class) == null) continue;
            qualifiers.add(annotation);
        }
        return !qualifiers.isEmpty() ? qualifiers.toArray(new Annotation[qualifiers.size()]) : ReflectionUtils.EMPTY_ANNOTATIONS;
    }

    public static Annotation[] parseQualifiers(Field field) {
        return AnnotationUtils.parseQualifiers(field.getDeclaredAnnotations());
    }

    public static Annotation[] parseQualifiers(Method method) {
        return AnnotationUtils.parseQualifiers(method.getDeclaredAnnotations());
    }

    public static Annotation[] parseQualifiers(Parameter parameter) {
        return AnnotationUtils.parseQualifiers(parameter.getDeclaredAnnotations());
    }

    public static Annotation[] parseQualifiers(Class<?> clazz) {
        return AnnotationUtils.parseQualifiers(clazz.getDeclaredAnnotations());
    }
}

