/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jdbc;

import com.appslandia.common.base.InitializeException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharsetUtils;
import com.appslandia.common.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DataSourceImpl
extends InitializeObject
implements DataSource {
    private String url;
    private String userName;
    private String password;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.url, "url is required.");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.initialize();
        Connection conn = null;
        conn = this.userName != null ? DriverManager.getConnection(this.url, this.userName, this.password) : DriverManager.getConnection(this.url);
        return conn;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public DataSourceImpl load(String file) {
        return this.load(new File(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataSourceImpl load(File file) {
        this.assertNotInitialized();
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CharsetUtils.UTF_8));){
            DataSourceImpl dataSourceImpl = this.load(r);
            return dataSourceImpl;
        }
        catch (InitializeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InitializeException(ex);
        }
    }

    public DataSourceImpl load(InputStream is) {
        this.assertNotInitialized();
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (Exception ex) {
            throw new InitializeException(ex);
        }
        this.initProperties(props);
        return this;
    }

    public DataSourceImpl load(Reader r) {
        this.assertNotInitialized();
        Properties props = new Properties();
        try {
            props.load(r);
        }
        catch (Exception ex) {
            throw new InitializeException(ex);
        }
        this.initProperties(props);
        return this;
    }

    protected void initProperties(Properties props) {
        this.setUrl(props.getProperty("url"));
        this.setUserName(props.getProperty("userName"));
        this.setPassword(props.getProperty("password"));
    }

    public String getUrl() {
        return this.url;
    }

    public DataSourceImpl setUrl(String url) {
        this.assertNotInitialized();
        this.url = StringUtils.trimToNull(url);
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public DataSourceImpl setUserName(String userName) {
        this.assertNotInitialized();
        this.userName = StringUtils.trimToNull(userName);
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public DataSourceImpl setPassword(String password) {
        this.assertNotInitialized();
        this.password = StringUtils.trimToNull(password);
        return this;
    }
}

