/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.NumberFormatter;
import java.text.NumberFormat;

public class FloatFormatter
extends NumberFormatter {
    public static final String ERROR_MSG_KEY = FloatFormatter.class.getName() + ".message";

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgumentType() {
        return Float.class;
    }

    @Override
    protected NumberFormat getNumberFormat(FormatProvider formatProvider) {
        return formatProvider.getNumberFormat();
    }

    @Override
    public Float parse(String str, FormatProvider formatProvider) throws FormatterException {
        double posDouble;
        Number number = this.parseNumber(str, formatProvider);
        if (number == null) {
            return null;
        }
        double doubleValue = number.doubleValue();
        double d = posDouble = doubleValue >= 0.0 ? doubleValue : doubleValue * -1.0;
        if (posDouble != 0.0 && (posDouble < (double)1.4E-45f || posDouble > 3.4028234663852886E38)) {
            throw this.parsedOverflowException(str);
        }
        return Float.valueOf(number.floatValue());
    }
}

