/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.FormatterException;
import java.util.Locale;

public class BooleanFormatter
extends Formatter {
    public static final String ERROR_MSG_KEY = BooleanFormatter.class.getName() + ".message";
    public static final String VALUE_TRUE = Boolean.TRUE.toString();
    public static final String VALUE_FALSE = Boolean.FALSE.toString();

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgumentType() {
        return Boolean.class;
    }

    @Override
    public String format(Object obj, FormatProvider formatProvider) {
        if (obj == null) {
            return null;
        }
        return Boolean.TRUE.equals(obj) ? VALUE_TRUE : VALUE_FALSE;
    }

    @Override
    public Boolean parse(String str, FormatProvider formatProvider) throws FormatterException {
        if (str == null) {
            return null;
        }
        String val = str.toLowerCase(Locale.ENGLISH);
        if (VALUE_TRUE.equals(val)) {
            return Boolean.TRUE;
        }
        if (VALUE_FALSE.equals(val)) {
            return Boolean.FALSE;
        }
        throw new FormatterException("An error occurred while parsing java.lang.Boolean (str=" + str + ")", this.getErrorMsgKey());
    }
}

