/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.easyrecord;

import com.appslandia.common.base.ToStringBuilder;
import com.appslandia.common.easyrecord.BitValuesValidator;
import com.appslandia.common.easyrecord.Field;
import com.appslandia.common.easyrecord.FieldValidator;
import com.appslandia.common.easyrecord.MaxLengthValidator;
import com.appslandia.common.easyrecord.PatternValidator;
import com.appslandia.common.easyrecord.Record;
import com.appslandia.common.easyrecord.RequiredValidator;
import com.appslandia.common.easyrecord.Table;
import com.appslandia.common.easyrecord.ValidValuesValidator;
import com.appslandia.common.easyrecord.ValidatorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldValidators {
    final Map<String, FieldValidator> validators = new HashMap<String, FieldValidator>();

    public FieldValidators() {
        this.initialize();
    }

    protected void initialize() {
        this.putValidator("required", new RequiredValidator());
        this.putValidator("bitValues", new BitValuesValidator());
        this.putValidator("maxLength", new MaxLengthValidator());
        this.putValidator("validValues", new ValidValuesValidator());
        this.putValidator("pattern", new PatternValidator());
    }

    public FieldValidator getValidator(String name) throws IllegalArgumentException {
        FieldValidator validator = this.validators.get(name);
        if (validator == null) {
            throw new IllegalArgumentException("Validator is required (name=" + name + ")");
        }
        return validator;
    }

    public void putValidator(String name, FieldValidator validator) {
        this.validators.put(name, validator);
    }

    public void validateField(Field field, Object value, List<FieldValidator.FieldError> errors) {
        for (Map.Entry<String, Object> constraint : field.getConstraints().entrySet()) {
            FieldValidator.FieldError error = this.getValidator(constraint.getKey()).validate(value, field.getConstraintArgs(constraint.getKey()));
            if (error == null) continue;
            errors.add(error);
        }
    }

    public void validateRecord(Record record, Table table, Callback callback) {
        ArrayList<FieldValidator.FieldError> errors = new ArrayList<FieldValidator.FieldError>(2);
        for (Field field : table.getFields()) {
            this.validateField(field, record.get(field.getName()), errors);
            if (errors.isEmpty()) continue;
            callback.onError(field.getName(), errors);
        }
    }

    public void validateKey(Record key, Table table, Callback callback) {
        ArrayList<FieldValidator.FieldError> errors = new ArrayList<FieldValidator.FieldError>(2);
        for (Field field : table.getFields()) {
            if (!field.isKey()) continue;
            this.validateField(field, key.get(field.getName()), errors);
            if (errors.isEmpty()) continue;
            callback.onError(field.getName(), errors);
        }
    }

    public void validateRecord(Record record, Table table) throws ValidatorException {
        ArrayList<FieldValidator.FieldError> errors = new ArrayList<FieldValidator.FieldError>(2);
        for (Field field : table.getFields()) {
            this.validateField(field, record.get(field.getName()), errors);
            if (errors.isEmpty()) continue;
            throw new ValidatorException("field=" + field.getName() + ", errors=" + new ToStringBuilder(3).toString(errors));
        }
    }

    public void validateKey(Record key, Table table) throws ValidatorException {
        ArrayList<FieldValidator.FieldError> errors = new ArrayList<FieldValidator.FieldError>(2);
        for (Field field : table.getFields()) {
            if (!field.isKey()) continue;
            this.validateField(field, key.get(field.getName()), errors);
            if (errors.isEmpty()) continue;
            throw new ValidatorException("field=" + field.getName() + ", errors=" + new ToStringBuilder(3).toString(errors));
        }
    }

    public static interface Callback {
        public void onError(String var1, List<FieldValidator.FieldError> var2);
    }
}

