/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.crypto.MbeDigester;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;

public class MbeSigner
extends InitializeObject
implements Encryptor {
    private MbeDigester signer;

    public MbeSigner() {
    }

    public MbeSigner(MbeDigester signer) {
        this.signer = signer;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.signer, "signer is required.");
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.signer != null) {
            this.signer.destroy();
        }
        super.destroy();
    }

    @Override
    public byte[] encrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        byte[] digested = this.signer.digest(message);
        return ArrayUtils.append(digested, message);
    }

    @Override
    public byte[] decrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        int digestLength = this.signer.getDigestLength();
        AssertUtils.assertTrue(message.length > digestLength, "message is invalid.");
        byte[] digested = new byte[digestLength];
        byte[] parsedMsg = new byte[message.length - digestLength];
        ArrayUtils.copy(message, digested, parsedMsg);
        if (!this.signer.verify(parsedMsg, digested)) {
            throw new CryptoException("message was tampered.");
        }
        return parsedMsg;
    }

    public MbeSigner setSigner(MbeDigester signer) {
        this.assertNotInitialized();
        this.signer = signer;
        return this;
    }

    @Override
    public MbeSigner copy() {
        MbeSigner impl = new MbeSigner();
        if (this.signer != null) {
            impl.signer = this.signer.copy();
        }
        return impl;
    }
}

