/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.crypto.KeyFactoryUtil;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public class DsaDigester
extends InitializeObject
implements Digester {
    private String algorithm;
    private String provider;
    private Signature digester;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    final Object mutex = new Object();

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.algorithm, "algorithm is required.");
        AssertUtils.assertTrue(this.privateKey != null || this.publicKey != null, "No key is provided.");
        this.digester = this.provider == null ? Signature.getInstance(this.algorithm) : Signature.getInstance(this.algorithm, this.provider);
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.privateKey != null) {
            CryptoUtils.tryDestroy(this.privateKey);
        }
        super.destroy();
    }

    @Override
    public int getDigestLength() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] digest(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(this.privateKey, "privateKey is required.");
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.digester.initSign(this.privateKey);
                this.digester.update(message);
                return this.digester.sign();
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(byte[] message, byte[] signature) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(signature, "signature is required.");
        AssertUtils.assertNotNull(this.publicKey, "publicKey is required.");
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.digester.initVerify(this.publicKey);
                this.digester.update(message);
                return this.digester.verify(signature);
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    public DsaDigester setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = StringUtils.trimToNull(algorithm);
        return this;
    }

    public DsaDigester setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = StringUtils.trimToNull(provider);
        return this;
    }

    public DsaDigester setPrivateKey(PrivateKey privateKey) {
        this.assertNotInitialized();
        this.privateKey = privateKey;
        return this;
    }

    public DsaDigester setPublicKey(PublicKey publicKey) {
        this.assertNotInitialized();
        this.publicKey = publicKey;
        return this;
    }

    public DsaDigester setKeyPair(KeyPair keyPair) {
        this.assertNotInitialized();
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
        return this;
    }

    @Override
    public DsaDigester copy() {
        DsaDigester impl = new DsaDigester().setAlgorithm(this.algorithm).setProvider(this.provider);
        KeyFactoryUtil keyUtil = new KeyFactoryUtil();
        if (this.privateKey != null) {
            keyUtil.setAlgorithm(this.privateKey.getAlgorithm());
            impl.privateKey = keyUtil.copy(this.privateKey);
        }
        if (this.publicKey != null) {
            if (this.privateKey == null) {
                keyUtil.setAlgorithm(this.publicKey.getAlgorithm());
            }
            impl.publicKey = keyUtil.copy(this.publicKey);
        }
        return impl;
    }
}

