/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.Permutation;
import com.appslandia.common.base.TextGenerator;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharUtils;
import com.appslandia.common.utils.RandomUtils;
import java.security.SecureRandom;
import java.util.Random;
import java.util.regex.Pattern;

public class WordsGenerator
extends InitializeObject
implements TextGenerator {
    private static final char[] UPPER_CASES = CharUtils.toCharRanges("A-Z");
    private static final char[] LOWER_CASES = CharUtils.toCharRanges("a-z");
    private static final char[] DIGITS = CharUtils.toCharRanges("0-9");
    private static final Pattern ALPHABET_PATTERN = Pattern.compile("[a-zA-Z\\d]+");
    private int length;
    final Random random = new SecureRandom();

    @Override
    protected void init() throws Exception {
        AssertUtils.assertTrue(this.length > 0, "length is required.");
    }

    @Override
    public String generate() {
        this.initialize();
        return this.generate(new char[][]{UPPER_CASES, LOWER_CASES, DIGITS});
    }

    private String generate(char[][] sources) {
        int len = Math.max(this.length, sources.length);
        char[] rdChars = new char[len];
        int avgChars = len / sources.length;
        int emptyCount = len;
        Permutation sourceIndexes = new Permutation(sources.length);
        while (sourceIndexes.hasNext()) {
            int rdCount = RandomUtils.nextInt(this.random, 1, avgChars);
            emptyCount = WordsGenerator.randomChars(this.random, sources[sourceIndexes.next()], rdChars, rdCount, emptyCount);
        }
        for (int i = 0; i < len; ++i) {
            if (rdChars[i] != '\u0000') continue;
            char[] nextSource = sources[this.random.nextInt(sources.length)];
            rdChars[i] = nextSource[this.random.nextInt(nextSource.length)];
        }
        return new String(rdChars, 0, this.length);
    }

    @Override
    public boolean verify(String value) {
        AssertUtils.assertNotNull(value);
        if (value.length() != this.length) {
            return false;
        }
        return ALPHABET_PATTERN.matcher(value).matches();
    }

    public WordsGenerator setLength(int length) {
        this.assertNotInitialized();
        this.length = length;
        return this;
    }

    public static int randomChars(Random random, char[] src, char[] dest, int rdCount, int emptyCount) {
        for (int i = 0; i < rdCount; ++i) {
            int index = WordsGenerator.randomEmptyIndex(random, dest, emptyCount);
            dest[index] = src[random.nextInt(src.length)];
            --emptyCount;
        }
        return emptyCount;
    }

    private static int randomEmptyIndex(Random random, char[] dest, int emptyCount) {
        int rdIndex = random.nextInt(emptyCount);
        int idx = -1;
        for (int i = 0; i < dest.length; ++i) {
            if (dest[i] != '\u0000' || ++idx != rdIndex) continue;
            return i;
        }
        return 0;
    }
}

