/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.ConfigBase;
import com.appslandia.common.utils.DateUtils;
import com.appslandia.common.utils.StringUtils;
import com.appslandia.common.utils.URLEncoding;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueryParams
extends ConfigBase {
    private static final long serialVersionUID = 1L;

    public QueryParams() {
        super(new LinkedHashMap<String, String>());
    }

    public QueryParams(Map<String, String> newMap) {
        super(newMap);
    }

    public QueryParams parse(String queryString) {
        int endIdx;
        int startIdx = 0;
        while ((endIdx = queryString.indexOf(38, startIdx)) != -1) {
            this.parseNameVal(queryString.substring(startIdx, endIdx));
            startIdx = endIdx + 1;
        }
        if (startIdx < queryString.length()) {
            this.parseNameVal(queryString.substring(startIdx));
        }
        return this;
    }

    private void parseNameVal(String nameVal) {
        int idx = nameVal.indexOf(61);
        if (idx <= 0) {
            return;
        }
        String name = nameVal.substring(0, idx).trim();
        if (name.isEmpty()) {
            return;
        }
        String value = nameVal.substring(idx + 1).trim();
        if (value.isEmpty()) {
            this.configs.put(name, null);
        } else {
            this.configs.put(name, URLEncoding.decode(value));
        }
    }

    public String toString() {
        if (this.configs.isEmpty()) {
            return null;
        }
        return this.toBuilder().toString();
    }

    public StringBuilder toBuilder() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.configs.entrySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append((String)entry.getKey()).append('=');
            if (entry.getValue() == null) continue;
            sb.append(URLEncoding.encode((String)entry.getValue()));
        }
        return sb;
    }

    public QueryParams param(String key, String value) {
        this.configs.put(key, StringUtils.trimToNull(value));
        return this;
    }

    public QueryParams param(String key, boolean value) {
        this.configs.put(key, Boolean.toString(value));
        return this;
    }

    public QueryParams param(String key, int value) {
        this.configs.put(key, Integer.toString(value));
        return this;
    }

    public QueryParams param(String key, long value) {
        this.configs.put(key, Long.toString(value));
        return this;
    }

    public QueryParams param(String key, float value) {
        this.configs.put(key, Float.toString(value));
        return this;
    }

    public QueryParams param(String key, double value) {
        this.configs.put(key, Double.toString(value));
        return this;
    }

    public QueryParams param(String key, Boolean value) {
        this.configs.put(key, value != null ? value.toString() : null);
        return this;
    }

    public QueryParams param(String key, Integer value) {
        this.configs.put(key, value != null ? value.toString() : null);
        return this;
    }

    public QueryParams param(String key, Long value) {
        this.configs.put(key, value != null ? value.toString() : null);
        return this;
    }

    public QueryParams param(String key, Float value) {
        this.configs.put(key, value != null ? value.toString() : null);
        return this;
    }

    public QueryParams param(String key, Double value) {
        this.configs.put(key, value != null ? value.toString() : null);
        return this;
    }

    public QueryParams param(String key, Date value) {
        this.configs.put(key, value != null ? DateUtils.iso8601Date(value) : null);
        return this;
    }

    public QueryParams param(String key, Time value) {
        this.configs.put(key, value != null ? DateUtils.iso8601Time(value) : null);
        return this;
    }

    public QueryParams param(String key, Timestamp value) {
        this.configs.put(key, value != null ? DateUtils.iso8601DateTime(value) : null);
        return this;
    }
}

