/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.InitializeException;
import com.appslandia.common.utils.AssertUtils;

public enum DeployPhase {
    DEVELOPMENT,
    TESTING,
    STAGING,
    PRODUCTION;

    private static volatile DeployPhase current;
    private static final Object MUTEX;
    public static final String SYSTEM_PROP_DEPLOY_PHASE = "__deployPhase";

    public boolean isDevelopment() {
        return this == DEVELOPMENT;
    }

    public boolean isTesting() {
        return this == TESTING;
    }

    public boolean isStaging() {
        return this == STAGING;
    }

    public boolean isProduction() {
        return this == PRODUCTION;
    }

    public boolean isNotProduction() {
        return this != PRODUCTION;
    }

    public boolean isAny(DeployPhase ... phases) {
        for (DeployPhase phase : phases) {
            if (this != phase) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeployPhase getCurrent() {
        DeployPhase obj = current;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = current;
                if (obj == null) {
                    current = obj = DeployPhase.initDeployPhase();
                }
            }
        }
        return obj;
    }

    public static void setCurrent(DeployPhase phrase) {
        AssertUtils.assertNull((Object)current);
        current = phrase;
    }

    private static DeployPhase initDeployPhase() {
        try {
            String phase = System.getProperty(SYSTEM_PROP_DEPLOY_PHASE, DEVELOPMENT.name());
            return DeployPhase.valueOf(phase);
        }
        catch (Exception ex) {
            throw new InitializeException(ex);
        }
    }

    static {
        MUTEX = new Object();
    }
}

