/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.utils.CharUtils;

public class Base16 {
    private static final char[] HEX_CHARS = CharUtils.toCharRanges("0-9A-F");

    private Base16() {
    }

    public static Encoder getEncoder() {
        return Encoder.INSTANCE;
    }

    public static Decoder getDecoder() {
        return Decoder.INSTANCE;
    }

    public static class Decoder {
        static final Decoder INSTANCE = new Decoder();

        private Decoder() {
        }

        public byte[] decode(byte[] src) {
            byte[] dest = new byte[src.length / 2];
            int i = 0;
            for (int j = 0; j < dest.length; ++j) {
                byte v1 = src[j * 2];
                byte v2 = src[j * 2 + 1];
                if (v1 < 0 || v1 > 15) {
                    throw new IllegalArgumentException("src is invalid base16.");
                }
                if (v2 < 0 || v2 > 15) {
                    throw new IllegalArgumentException("src is invalid base16.");
                }
                dest[i++] = (byte)((v1 << 4) + v2);
            }
            return dest;
        }

        public byte[] decodeFromChars(char[] src) {
            byte[] dest = new byte[src.length / 2];
            int i = 0;
            for (int j = 0; j < dest.length; ++j) {
                int v1 = Character.digit(src[j * 2], 16);
                int v2 = Character.digit(src[j * 2 + 1], 16);
                if (v1 < 0 || v1 > 15) {
                    throw new IllegalArgumentException("src is invalid base16.");
                }
                if (v2 < 0 || v2 > 15) {
                    throw new IllegalArgumentException("src is invalid base16.");
                }
                dest[i++] = (byte)((v1 << 4) + v2);
            }
            return dest;
        }

        public byte[] decodeFromString(String src) {
            return this.decodeFromChars(src.toCharArray());
        }
    }

    public static class Encoder {
        static final Encoder INSTANCE = new Encoder();

        private Encoder() {
        }

        public byte[] encode(byte[] src) {
            byte[] dest = new byte[src.length * 2];
            int i = 0;
            for (byte b : src) {
                dest[i++] = (byte)((b & 0xF0) >> 4);
                dest[i++] = (byte)(b & 0xF);
            }
            return dest;
        }

        public char[] encodeToChars(byte[] src) {
            char[] dest = new char[src.length * 2];
            int i = 0;
            for (byte b : src) {
                dest[i++] = HEX_CHARS[(b & 0xF0) >> 4];
                dest[i++] = HEX_CHARS[b & 0xF];
            }
            return dest;
        }

        public String encodeToString(byte[] src) {
            return new String(this.encodeToChars(src));
        }
    }
}

