/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.utils.AssertUtils;
import java.util.Arrays;

public enum BOM {
    UTF_8("UTF-8", new byte[]{-17, -69, -65}),
    UTF_16BE("UTF-16BE", new byte[]{-2, -1}),
    UTF_16LE("UTF-16LE", new byte[]{-1, -2}),
    UTF_32BE("UTF-32BE", new byte[]{0, 0, -2, -1}),
    UTF_32LE("UTF-32LE", new byte[]{-1, -2, 0, 0});

    final String encoding;
    final byte[] bytes;

    private BOM(String encoding, byte[] bytes) {
        this.encoding = encoding;
        this.bytes = bytes;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public int length() {
        return this.bytes.length;
    }

    public static BOM parse(String encoding) {
        if (encoding == null) {
            return null;
        }
        for (BOM bom : BOM.values()) {
            if (!bom.encoding.equalsIgnoreCase(encoding)) continue;
            return bom;
        }
        return null;
    }

    public static BOM parse(byte[] bom, int c) {
        AssertUtils.assertTrue(bom.length == 4);
        AssertUtils.assertTrue(c <= 4);
        if (c == 4) {
            if (UTF_32BE.matches(bom)) {
                return UTF_32BE;
            }
            if (UTF_32LE.matches(bom)) {
                return UTF_32LE;
            }
        }
        if (c >= 3 && UTF_8.matches(bom)) {
            return UTF_8;
        }
        if (c >= 2) {
            if (UTF_16BE.matches(bom)) {
                return UTF_16BE;
            }
            if (UTF_16LE.matches(bom)) {
                return UTF_16LE;
            }
        }
        return null;
    }

    private boolean matches(byte[] bom) {
        for (int i = 0; i < this.length(); ++i) {
            if (this.bytes[i] == bom[i]) continue;
            return false;
        }
        return true;
    }
}

