// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.base;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;

import com.appslandia.common.utils.RandomUtils;

/**
 *
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 *
 */
public class Permutation {

	final int n;
	private byte[] flags;
	private int remaining;

	final Random random = new SecureRandom();

	public Permutation(int n) {
		this.n = n;
	}

	private void initialize() {
		if (this.flags == null) {
			this.flags = new byte[this.n];
			this.remaining = this.n;
		}
	}

	public int next() {
		initialize();
		if (this.remaining == 0) {
			throw new NoSuchElementException("Permutation.next()");
		}
		int rdIndex = RandomUtils.nextInt(this.random, 0, this.remaining - 1);
		int index = -1;
		for (int i = 0; i < this.n; i++) {
			if (this.flags[i] == 0) {
				index++;
				if (index == rdIndex) {
					this.flags[i] = 1;
					this.remaining--;
					return i;
				}
			}
		}
		return -1;
	}

	public boolean hasNext() {
		initialize();
		return this.remaining > 0;
	}

	public void reset() {
		if (this.flags != null) {
			Arrays.fill(this.flags, (byte) 0);
			this.remaining = this.n;
		}
	}
}
