/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class SplitUtils {
    private static final Pattern COMMA_SEP_PATTERN = Pattern.compile(",");
    private static final Pattern LINE_SEP_PATTERN = Pattern.compile("\r?\n");
    private static final Pattern WHITESPACE_SEP_PATTERN = Pattern.compile("\\s");

    public static List<String> splitByComma(String str) {
        return SplitUtils.split(str, COMMA_SEP_PATTERN);
    }

    public static List<String> splitByLineSep(String str) {
        return SplitUtils.split(str, LINE_SEP_PATTERN);
    }

    public static List<String> splitByWhitespace(String str) {
        return SplitUtils.split(str, WHITESPACE_SEP_PATTERN);
    }

    public static List<String> split(String str, Pattern separator) {
        String[] items = separator.split(str);
        ArrayList<String> list = new ArrayList<String>(items.length);
        for (String item : items) {
            if ((item = item.trim()).length() <= 0) continue;
            list.add(item);
        }
        return list;
    }

    public static List<String> split(String str, char separator) {
        String item;
        int endIdx;
        int startIdx = 0;
        ArrayList<String> list = new ArrayList<String>();
        while ((endIdx = str.indexOf(separator, startIdx)) != -1) {
            item = str.substring(startIdx, endIdx).trim();
            if (!item.isEmpty()) {
                list.add(item);
            }
            startIdx = endIdx + 1;
        }
        if (startIdx < str.length() && !(item = str.substring(startIdx).trim()).isEmpty()) {
            list.add(item);
        }
        return list;
    }
}

