/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.Base16;
import com.appslandia.common.base.Base64;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharUtils;
import com.appslandia.common.utils.CharsetUtils;

public class BaseEncodingUtils {
    public static final String ENCODING_HEX = "hex";
    public static final String ENCODING_BASE64 = "base64";
    public static final String ENCODING_URL_BASE64 = "urlBase64";
    private static final char[] HEX_CHARS = CharUtils.toCharRange("0-9a-f");

    public static boolean isEncodingSupported(String baseEncoding) {
        return ENCODING_BASE64.equalsIgnoreCase(baseEncoding) || ENCODING_URL_BASE64.equalsIgnoreCase(baseEncoding) || ENCODING_HEX.equalsIgnoreCase(baseEncoding);
    }

    public static String encode(byte[] src, String baseEncoding) {
        AssertUtils.assertTrue(BaseEncodingUtils.isEncodingSupported(baseEncoding));
        if (ENCODING_BASE64.equalsIgnoreCase(baseEncoding)) {
            return BaseEncodingUtils.encodeBase64ToString(src);
        }
        if (ENCODING_HEX.equalsIgnoreCase(baseEncoding)) {
            return Base16.getEncoder().encodeToString(src);
        }
        return BaseEncodingUtils.urlEncodeBase64ToString(src);
    }

    public static byte[] decode(String src, String baseEncoding) {
        AssertUtils.assertTrue(BaseEncodingUtils.isEncodingSupported(baseEncoding));
        if (ENCODING_BASE64.equalsIgnoreCase(baseEncoding)) {
            return BaseEncodingUtils.decodeBase64FromString(src);
        }
        if (ENCODING_HEX.equalsIgnoreCase(baseEncoding)) {
            return Base16.getDecoder().decodeFromString(src);
        }
        return BaseEncodingUtils.urlDecodeBase64FromString(src);
    }

    public static String encodeBase64ToString(byte[] src) {
        return new String(Base64.getDelegate().encode(src), CharsetUtils.ISO_8859_1);
    }

    public static byte[] decodeBase64FromString(String src) {
        return Base64.getDelegate().decode(src.getBytes(CharsetUtils.ISO_8859_1));
    }

    public static String encodeBase64(String src) {
        return BaseEncodingUtils.encodeBase64ToString(src.getBytes(CharsetUtils.UTF_8));
    }

    public static String decodeBase64(String src) {
        return new String(BaseEncodingUtils.decodeBase64FromString(src), CharsetUtils.UTF_8);
    }

    public static String urlEncodeBase64ToString(byte[] src) {
        return new String(Base64.getDelegate().urlEncode(src), CharsetUtils.ISO_8859_1);
    }

    public static byte[] urlDecodeBase64FromString(String src) {
        return Base64.getDelegate().urlDecode(src.getBytes(CharsetUtils.ISO_8859_1));
    }

    public static String urlEncodeBase64(String src) {
        return BaseEncodingUtils.urlEncodeBase64ToString(src.getBytes(CharsetUtils.UTF_8));
    }

    public static String urlDecodeBase64(String src) {
        return new String(BaseEncodingUtils.urlDecodeBase64FromString(src), CharsetUtils.UTF_8);
    }

    public static void appendAsHex(StringBuilder builder, byte[] src) {
        for (byte b : src) {
            builder.append(HEX_CHARS[(b & 0xF0) >> 4]);
            builder.append(HEX_CHARS[b & 0xF]);
        }
    }
}

