/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.objects;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.objects.AnnotationUtils;
import com.appslandia.common.objects.ObjectException;
import com.appslandia.common.objects.ObjectProducer;
import com.appslandia.common.objects.ObjectScope;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class ObjectFactory
extends InitializeObject {
    protected final Set<ObjectInst> objectInsts = new LinkedHashSet<ObjectInst>();
    protected final Map<KeyDesc, ObjectInst> objectInstMap = new ConcurrentHashMap<KeyDesc, ObjectInst>();

    @Override
    protected void init() throws Exception {
        this.validateFactory();
    }

    protected void validateFactory() throws ObjectException {
        for (ObjectInst objInst : this.objectInsts) {
            if (objInst.getProducer() != null) continue;
            new InjectTraverser(){

                @Override
                public boolean isValidating() {
                    return true;
                }

                @Override
                public void onParameter(Parameter parameter) throws ObjectException {
                    this.validateInject(parameter.getType(), AnnotationUtils.parseQualifiers(parameter), parameter);
                }

                @Override
                public void onField(Field field) throws ObjectException {
                    this.validateInject(field.getType(), AnnotationUtils.parseQualifiers(field), field);
                }

                @Override
                public void onMethod(Method method) throws ObjectException {
                    throw new UnsupportedOperationException();
                }

                private String toString(AnnotatedElement element) {
                    if (element instanceof Parameter) {
                        return ((Parameter)element).getDeclaringExecutable().toString();
                    }
                    return element.toString();
                }

                private void validateInject(Class<?> type, Annotation[] qualifiers, AnnotatedElement element) throws ObjectException {
                    if (ObjectFactory.class.isAssignableFrom(type)) {
                        return;
                    }
                    int count = ObjectFactory.this.countDependencies(type, qualifiers);
                    if (count == 0) {
                        throw new ObjectException("Unsatisfied dependency (type=" + type + ", qualifiers=" + Arrays.toString(qualifiers) + ", location=" + this.toString(element) + ")");
                    }
                    if (count > 1) {
                        throw new ObjectException("Ambiguous dependency (type=" + type + ", qualifiers=" + Arrays.toString(qualifiers) + ", location=" + this.toString(element) + ")");
                    }
                }
            }.traverse(objInst.getType());
        }
    }

    protected int countDependencies(Class<?> type, Annotation[] qualifiers) {
        int count = 0;
        for (ObjectInst objInst : this.objectInsts) {
            if (!type.isAssignableFrom(objInst.getType()) || !AnnotationUtils.equals(qualifiers, objInst.getQualifiers())) continue;
            ++count;
        }
        return count;
    }

    public <T> ObjectFactory register(Class<T> type, ObjectProducer<T> producer) throws ObjectException {
        return this.register(type, producer, ObjectScope.SINGLETON, ReflectionUtils.EMPTY_ANNOTATIONS);
    }

    public <T> ObjectFactory register(Class<T> type, ObjectProducer<T> producer, ObjectScope scope) throws ObjectException {
        return this.register(type, producer, scope, ReflectionUtils.EMPTY_ANNOTATIONS);
    }

    public <T> ObjectFactory register(Class<T> type, ObjectProducer<T> producer, ObjectScope scope, Annotation ... qualifiers) throws ObjectException {
        this.assertNotInitialized();
        AssertUtils.assertNotNull(type);
        AssertUtils.assertNotNull(producer);
        AssertUtils.assertNotNull(scope);
        ObjectInst objInst = new ObjectInst().setType(type).setQualifiers(qualifiers);
        objInst.setScope(scope);
        objInst.setProducer(producer);
        this.objectInsts.add(objInst);
        return this;
    }

    public ObjectFactory register(Class<?> objectClass) throws ObjectException {
        return this.register(objectClass, ObjectScope.SINGLETON);
    }

    public ObjectFactory register(Class<?> objectClass, ObjectScope scope) throws ObjectException {
        this.assertNotInitialized();
        AssertUtils.assertNotNull(objectClass);
        AssertUtils.assertNotNull(scope);
        AssertUtils.assertTrue(!Modifier.isAbstract(objectClass.getModifiers()));
        ObjectInst objInst = new ObjectInst().setType(objectClass).setQualifiers(AnnotationUtils.parseQualifiers(objectClass));
        objInst.setScope(scope);
        this.objectInsts.add(objInst);
        return this;
    }

    public ObjectFactory register(Class<?> objectClass, ObjectScope scope, Annotation ... qualifiers) throws ObjectException {
        this.assertNotInitialized();
        AssertUtils.assertNotNull(objectClass);
        AssertUtils.assertNotNull(scope);
        AssertUtils.assertTrue(!Modifier.isAbstract(objectClass.getModifiers()));
        ObjectInst objInst = new ObjectInst().setType(objectClass).setQualifiers(qualifiers);
        objInst.setScope(scope);
        this.objectInsts.add(objInst);
        return this;
    }

    public ObjectFactory inject(final Object obj) throws ObjectException {
        AssertUtils.assertNotNull(obj);
        new InjectTraverser(){

            @Override
            public boolean isValidating() {
                return false;
            }

            @Override
            public void onParameter(Parameter parameter) throws ObjectException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onField(Field field) throws ObjectException {
                try {
                    field.setAccessible(true);
                    Object value = ObjectFactory.this.getObject(field.getType(), AnnotationUtils.parseQualifiers(field));
                    field.set(obj, value);
                }
                catch (ObjectException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new ObjectException(ex);
                }
            }

            @Override
            public void onMethod(Method method) throws ObjectException {
                try {
                    method.setAccessible(true);
                    method.invoke(obj, ObjectFactory.this.createArguments(method.getParameters()));
                }
                catch (ObjectException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new ObjectException(ex);
                }
            }
        }.traverse(obj.getClass());
        return this;
    }

    protected Object[] createArguments(Parameter[] parameters) throws ObjectException {
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            args[i] = this.getObject(parameter.getType(), AnnotationUtils.parseQualifiers(parameter));
        }
        return args;
    }

    protected Object produceObject(ObjectInst objInst) throws ObjectException {
        try {
            if (objInst.getProducer() != null) {
                return objInst.getProducer().produce(this);
            }
            Constructor<?> emptyCtor = null;
            Constructor<?> injectCtor = null;
            for (Constructor<?> ctor : objInst.getType().getDeclaredConstructors()) {
                if (ctor.getDeclaredAnnotation(Inject.class) != null) {
                    injectCtor = ctor;
                    break;
                }
                if (ctor.getParameterCount() != 0) continue;
                emptyCtor = ctor;
            }
            if (injectCtor == null && emptyCtor == null) {
                throw new ObjectException("Could not instantiate (objectClass=" + objInst.getType() + ")");
            }
            Object instance = null;
            if (injectCtor != null) {
                injectCtor.setAccessible(true);
                instance = injectCtor.newInstance(this.createArguments(injectCtor.getParameters()));
            } else {
                emptyCtor.setAccessible(true);
                instance = emptyCtor.newInstance(ReflectionUtils.EMPTY_OBJECTS);
            }
            this.inject(instance).postConstruct(instance);
            return instance;
        }
        catch (ObjectException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ObjectException(ex);
        }
    }

    public <T> T getObject(Class<?> type) throws ObjectException {
        return this.getObject(type, ReflectionUtils.EMPTY_ANNOTATIONS);
    }

    protected ObjectInst getObjectInst(Class<?> type, Annotation[] qualifiers) {
        return this.objectInstMap.computeIfAbsent(new KeyDesc(type, qualifiers), key -> {
            for (ObjectInst objInst : this.objectInsts) {
                if (!key.getType().isAssignableFrom(objInst.getType()) || !AnnotationUtils.equals(key.getQualifiers(), objInst.getQualifiers())) continue;
                return objInst;
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getObject(Class<?> type, Annotation ... qualifiers) throws ObjectException {
        AssertUtils.assertNotNull(type);
        this.initialize();
        if (ObjectFactory.class.isAssignableFrom(type)) {
            return ObjectUtils.cast(this);
        }
        ObjectInst objInst = this.getObjectInst(type, qualifiers);
        if (objInst == null) {
            throw new ObjectException("Object is required (type=" + type + ", qualifiers=" + Arrays.toString(qualifiers) + ")");
        }
        if (objInst.getScope() == ObjectScope.PROTOTYPE) {
            return ObjectUtils.cast(this.produceObject(objInst));
        }
        if (objInst.getInstance() != null) {
            return ObjectUtils.cast(objInst.getInstance());
        }
        Object object = this.mutex;
        synchronized (object) {
            if (objInst.getInstance() == null) {
                objInst.setInstance(this.produceObject(objInst));
            }
            return ObjectUtils.cast(objInst.getInstance());
        }
    }

    public void postConstruct(Object obj) throws ObjectException {
        AssertUtils.assertNotNull(obj);
        this.invokeMethod(obj, PostConstruct.class);
    }

    public void preDestroy(Object obj) throws ObjectException {
        AssertUtils.assertNotNull(obj);
        this.invokeMethod(obj, PreDestroy.class);
    }

    @Override
    public void destroy() throws ObjectException {
        for (ObjectInst objInst : this.objectInsts) {
            if (objInst.getInstance() == null) continue;
            if (objInst.getProducer() == null) {
                this.preDestroy(objInst.getInstance());
            } else {
                objInst.getProducer().destroy(objInst.getInstance());
            }
            objInst.setInstance(null);
        }
    }

    protected void invokeMethod(Object obj, Class<? extends Annotation> annotationType) throws ObjectException {
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (method.getDeclaredAnnotation(annotationType) == null) continue;
                try {
                    method.setAccessible(true);
                    method.invoke(obj, new Object[0]);
                    return;
                }
                catch (ObjectException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new ObjectException(ex);
                }
            }
        }
    }

    public Iterator<ObjectDesc> getDescIterator() {
        return new Iterator<ObjectDesc>(){
            int index = -1;
            final Object[] objInsts;
            {
                this.objInsts = ObjectFactory.this.objectInsts.toArray();
            }

            @Override
            public ObjectDesc next() {
                ObjectInst objInst = (ObjectInst)this.objInsts[++this.index];
                return new ObjectDesc(objInst.getType(), objInst.getQualifiers());
            }

            @Override
            public boolean hasNext() {
                return this.index < this.objInsts.length - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected static class ObjectInst {
        private Class<?> type;
        private Annotation[] qualifiers;
        private ObjectScope scope;
        private ObjectProducer producer;
        private volatile Object instance;

        protected ObjectInst() {
        }

        public Class<?> getType() {
            return this.type;
        }

        public ObjectInst setType(Class<?> type) {
            this.type = type;
            return this;
        }

        public Annotation[] getQualifiers() {
            return this.qualifiers;
        }

        public ObjectInst setQualifiers(Annotation[] qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public ObjectScope getScope() {
            return this.scope;
        }

        public ObjectInst setScope(ObjectScope scope) {
            this.scope = scope;
            return this;
        }

        public ObjectProducer getProducer() {
            return this.producer;
        }

        public ObjectInst setProducer(ObjectProducer producer) {
            this.producer = producer;
            return this;
        }

        public Object getInstance() {
            return this.instance;
        }

        public ObjectInst setInstance(Object instance) {
            this.instance = instance;
            return this;
        }

        public int hashCode() {
            int hash = 1;
            int p = 31;
            hash = p * hash + Objects.hashCode(this.type);
            hash = p * hash + Arrays.hashCode(this.qualifiers);
            return hash;
        }

        public boolean equals(Object obj) {
            ObjectInst another = (ObjectInst)obj;
            return this.type == another.type && AnnotationUtils.equals(this.qualifiers, another.qualifiers);
        }

        public String toString() {
            return "type=" + this.type + ", qualifiers=" + Arrays.toString(this.qualifiers) + ", scope=" + (Object)((Object)this.scope) + ", producer=" + this.producer;
        }
    }

    public static class ObjectDesc {
        final Class<?> type;
        final Annotation[] qualifiers;

        public ObjectDesc(Class<?> type, Annotation[] qualifiers) {
            this.type = type;
            this.qualifiers = qualifiers;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Annotation[] getQualifiers() {
            return this.qualifiers;
        }

        public int hashCode() {
            int hash = 1;
            int p = 31;
            hash = p * hash + Objects.hashCode(this.type);
            hash = p * hash + Arrays.hashCode(this.qualifiers);
            return hash;
        }

        public boolean equals(Object obj) {
            ObjectDesc another = (ObjectDesc)obj;
            return this.type == another.type && AnnotationUtils.equals(this.qualifiers, another.qualifiers);
        }

        public String toString() {
            return "type=" + this.type + ", qualifiers=" + Arrays.toString(this.qualifiers);
        }
    }

    protected static class KeyDesc {
        final Class<?> type;
        final Annotation[] qualifiers;

        public KeyDesc(Class<?> type, Annotation[] qualifiers) {
            this.type = type;
            this.qualifiers = qualifiers;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Annotation[] getQualifiers() {
            return this.qualifiers;
        }

        public int hashCode() {
            int hash = 1;
            int p = 31;
            hash = p * hash + Objects.hashCode(this.type);
            hash = p * hash + Arrays.hashCode(this.qualifiers);
            return hash;
        }

        public boolean equals(Object obj) {
            KeyDesc another = (KeyDesc)obj;
            return this.type == another.type && AnnotationUtils.equals(this.qualifiers, another.qualifiers);
        }
    }

    protected static abstract class InjectTraverser {
        protected InjectTraverser() {
        }

        public abstract boolean isValidating();

        public abstract void onParameter(Parameter var1) throws ObjectException;

        public abstract void onField(Field var1) throws ObjectException;

        public abstract void onMethod(Method var1) throws ObjectException;

        public void traverse(Class<?> objectClass) throws ObjectException {
            Method[] methods;
            Class<?> clazz = null;
            if (this.isValidating()) {
                for (Constructor<?> ctor : objectClass.getDeclaredConstructors()) {
                    if (ctor.getDeclaredAnnotation(Inject.class) == null) continue;
                    for (Parameter parameter : ctor.getParameters()) {
                        this.onParameter(parameter);
                    }
                    break;
                }
                for (clazz = objectClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                    for (Method method : methods = clazz.getDeclaredMethods()) {
                        if (method.getDeclaredAnnotation(Inject.class) == null) continue;
                        for (Parameter parameter : method.getParameters()) {
                            this.onParameter(parameter);
                        }
                    }
                }
            }
            for (clazz = objectClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (field.getDeclaredAnnotation(Inject.class) == null) continue;
                    this.onField(field);
                }
            }
            if (!this.isValidating()) {
                for (clazz = objectClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                    for (Method method : methods = clazz.getDeclaredMethods()) {
                        if (method.getDeclaredAnnotation(Inject.class) == null) continue;
                        this.onMethod(method);
                    }
                }
            }
        }
    }
}

