/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jpa;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.MapAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.EntityGraph;
import javax.persistence.PessimisticLockScope;

public class JpaHints
extends InitializeObject
implements MapAccessor<String, Object> {
    public static final String CACHE_STORE_MODE = "javax.persistence.cache.storeMode";
    public static final String CACHE_RETRIEVE_MODE = "javax.persistence.cache.retrieveMode";
    public static final String JPA_FETCH_GRAPH = "javax.persistence.fetchgraph";
    public static final String JPA_LOAD_GRAPH = "javax.persistence.loadgraph";
    public static final String PESSIMISTIC_LOCK_SCOPE = "javax.persistence.lock.scope";
    public static final String PESSIMISTIC_LOCK_TIMEOUT = "javax.persistence.lock.timeout";
    public static final JpaHints CACHE_STORE_USE = (JpaHints)new JpaHints().hint("javax.persistence.cache.storeMode", CacheStoreMode.USE).initialize();
    public static final JpaHints CACHE_STORE_REFRESH = (JpaHints)new JpaHints().hint("javax.persistence.cache.storeMode", CacheStoreMode.REFRESH).initialize();
    public static final JpaHints CACHE_STORE_BYPASS = (JpaHints)new JpaHints().hint("javax.persistence.cache.storeMode", CacheStoreMode.BYPASS).initialize();
    public static final JpaHints CACHE_RETRIEVE_USE = (JpaHints)new JpaHints().hint("javax.persistence.cache.retrieveMode", CacheRetrieveMode.USE).initialize();
    public static final JpaHints CACHE_RETRIEVE_BYPASS = (JpaHints)new JpaHints().hint("javax.persistence.cache.retrieveMode", CacheRetrieveMode.BYPASS).initialize();
    public static final JpaHints PESSIMISTIC_LOCK_EXTENDED = (JpaHints)new JpaHints().hint("javax.persistence.lock.scope", PessimisticLockScope.EXTENDED).initialize();
    final Map<String, Object> hints = new HashMap<String, Object>();

    @Override
    protected void init() throws Exception {
    }

    public JpaHints hint(String key, Object value) {
        this.assertNotInitialized();
        this.hints.put(key, value);
        return this;
    }

    public JpaHints fetchgraph(EntityGraph<?> graph) {
        this.assertNotInitialized();
        this.hints.put(JPA_FETCH_GRAPH, graph);
        return this;
    }

    public JpaHints loadgraph(EntityGraph<?> graph) {
        this.assertNotInitialized();
        this.hints.put(JPA_LOAD_GRAPH, graph);
        return this;
    }

    @Override
    public int size() {
        this.initialize();
        return this.hints.size();
    }

    @Override
    public boolean isEmpty() {
        this.initialize();
        return this.hints.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.initialize();
        return this.hints.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        this.initialize();
        return this.hints.get(key);
    }

    @Override
    public Set<String> keySet() {
        this.initialize();
        return this.hints.keySet();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.initialize();
        return this.hints.entrySet();
    }
}

