/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.crypto.TextDigester;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.BaseEncodingUtils;
import com.appslandia.common.utils.RandomUtils;
import com.appslandia.common.utils.ValueUtils;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PasswordDigester
extends TextDigester {
    private int saltSize;
    private int iterationCount;
    private int keySize;
    private String secretKeyAlgorithm;
    private String provider;
    private SecretKeyFactory secretKeyFactory;
    final Random random = new SecureRandom();

    @Override
    protected void init() throws Exception {
        this.baseEncoding = ValueUtils.valueOrDefault(this.baseEncoding, "base64");
        AssertUtils.assertTrue(BaseEncodingUtils.isEncodingSupported(this.baseEncoding), "baseEncoding is not supported.");
        this.saltSize = Math.max(this.saltSize, 16);
        this.iterationCount = Math.max(this.iterationCount, 1000);
        this.keySize = ValueUtils.valueOrDefault(this.keySize, 32);
        AssertUtils.assertTrue(this.keySize > 0, "keySize is required.");
        this.secretKeyAlgorithm = ValueUtils.valueOrDefault(this.secretKeyAlgorithm, "PBKDF2WithHmacSHA512");
        this.secretKeyFactory = this.provider == null ? SecretKeyFactory.getInstance(this.secretKeyAlgorithm) : SecretKeyFactory.getInstance(this.secretKeyAlgorithm, this.provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String digest(String password) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(password, "password is required.");
        byte[] salt = RandomUtils.nextBytes(this.random, this.saltSize);
        char[] pwdChars = password.toCharArray();
        try {
            byte[] digested = this.generateSecret(pwdChars, salt);
            String string = BaseEncodingUtils.encode(ArrayUtils.append(salt, digested), this.baseEncoding);
            return string;
        }
        finally {
            CryptoUtils.clear(pwdChars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(String password, String digested) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(password, "password is required.");
        AssertUtils.assertNotNull(digested, "digested is required.");
        byte[] in = BaseEncodingUtils.decode(digested, this.baseEncoding);
        AssertUtils.assertTrue(in.length > this.saltSize, "digested is invalid.");
        byte[] salt = new byte[this.saltSize];
        byte[] pDigested = new byte[in.length - this.saltSize];
        ArrayUtils.copy(in, salt, pDigested);
        char[] pwdChars = password.toCharArray();
        try {
            byte[] gDigested = this.generateSecret(pwdChars, salt);
            boolean bl = Arrays.equals(gDigested, pDigested);
            return bl;
        }
        finally {
            CryptoUtils.clear(pwdChars);
        }
    }

    private byte[] generateSecret(char[] password, byte[] salt) throws CryptoException {
        PBEKeySpec keySpec = new PBEKeySpec(password, salt, this.iterationCount, this.keySize * 8);
        SecretKey secretkey = null;
        try {
            secretkey = this.secretKeyFactory.generateSecret(keySpec);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            keySpec.clearPassword();
        }
        byte[] encoded = secretkey.getEncoded();
        CryptoUtils.tryDestroy(secretkey);
        return encoded;
    }

    public PasswordDigester setSaltSize(int saltSize) {
        this.assertNotInitialized();
        this.saltSize = saltSize;
        return this;
    }

    public PasswordDigester setIterationCount(int iterationCount) {
        this.assertNotInitialized();
        this.iterationCount = iterationCount;
        return this;
    }

    public PasswordDigester setKeySize(int keySize) {
        this.assertNotInitialized();
        this.keySize = keySize;
        return this;
    }

    public PasswordDigester setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.assertNotInitialized();
        this.secretKeyAlgorithm = secretKeyAlgorithm;
        return this;
    }

    public PasswordDigester setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = provider;
        return this;
    }

    @Override
    public PasswordDigester setDigester(Digester digester) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PasswordDigester setTextCharset(Charset charset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PasswordDigester setTextCharset(String textCharset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PasswordDigester copy() {
        PasswordDigester impl = new PasswordDigester();
        impl.setSaltSize(this.saltSize).setIterationCount(this.iterationCount).setKeySize(this.keySize);
        impl.setSecretKeyAlgorithm(this.secretKeyAlgorithm).setProvider(this.provider);
        return impl;
    }
}

