/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.PKIUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class CertificateFactoryUtil
extends InitializeObject {
    private String type;
    private String provider;
    private CertificateFactory certificateFactory;

    public CertificateFactoryUtil() {
        this.type = "X.509";
    }

    public CertificateFactoryUtil(String type) {
        this.type = type;
    }

    public CertificateFactoryUtil(String type, String provider) {
        this.type = type;
        this.provider = provider;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.type, "type is required.");
        this.certificateFactory = this.provider == null ? CertificateFactory.getInstance(this.type) : CertificateFactory.getInstance(this.type, this.provider);
    }

    public X509Certificate toCertificate(InputStream certInDer) throws CryptoException {
        this.initialize();
        try {
            return (X509Certificate)this.certificateFactory.generateCertificate(certInDer);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    public X509Certificate toCertificate(String certInPem) throws CryptoException {
        this.initialize();
        byte[] der = PKIUtils.toDerEncoded(certInPem);
        try {
            return (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(der));
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    public CertificateFactoryUtil setType(String type) {
        this.assertNotInitialized();
        this.type = StringUtils.trimToNull(type);
        return this;
    }

    public CertificateFactoryUtil setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = StringUtils.trimToNull(provider);
        return this;
    }
}

