/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.cdi;

import com.appslandia.common.cdi.CDIFactory;
import com.appslandia.common.cdi.CDISupplier;
import com.appslandia.common.cdi.Supplier;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;

public class CDIUtils {
    public static <T> T getReference(BeanManager beanManager, Class<? extends T> type) {
        return CDIUtils.getReference(beanManager, type, ReflectionUtils.EMPTY_ANNOTATIONS);
    }

    public static <T> T getReference(BeanManager beanManager, Class<? extends T> type, Annotation ... qualifiers) {
        Set matchedBeans = beanManager.getBeans(type, qualifiers);
        if (matchedBeans.isEmpty()) {
            return null;
        }
        Bean bean = beanManager.resolve(matchedBeans);
        if (bean == null) {
            return null;
        }
        return ObjectUtils.cast(beanManager.getReference(bean, type, beanManager.createCreationalContext((Contextual)bean)));
    }

    public static <T> T getReference(BeanManager beanManager, String name) {
        Set matchedBeans = beanManager.getBeans(name);
        if (matchedBeans.isEmpty()) {
            return null;
        }
        Bean bean = beanManager.resolve(matchedBeans);
        if (bean == null) {
            return null;
        }
        return ObjectUtils.cast(beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext((Contextual)bean)));
    }

    public static <T> T getInstance(BeanManager beanManager, Class<? extends T> type) {
        return CDIUtils.getInstance(beanManager, type, ReflectionUtils.EMPTY_ANNOTATIONS);
    }

    public static <T> T getInstance(BeanManager beanManager, Class<? extends T> type, Annotation ... qualifiers) {
        Set matchedBeans = beanManager.getBeans(type, qualifiers);
        if (matchedBeans.isEmpty()) {
            return null;
        }
        Bean bean = (Bean)ObjectUtils.cast(beanManager.resolve(matchedBeans));
        if (bean == null) {
            return null;
        }
        return (T)beanManager.getContext(bean.getScope()).get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
    }

    public static <T> T getInstance(BeanManager beanManager, String name) {
        Set matchedBeans = beanManager.getBeans(name);
        if (matchedBeans.isEmpty()) {
            return null;
        }
        Bean bean = (Bean)ObjectUtils.cast(beanManager.resolve(matchedBeans));
        if (bean == null) {
            return null;
        }
        return (T)beanManager.getContext(bean.getScope()).get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
    }

    public static <T, A extends Annotation> void scanBeans(BeanManager beanManager, Class<T> type, Annotation[] qualifiers, Class<A> annotationClass, BiConsumer<A, T> consumer) {
        Set beans = (Set)ObjectUtils.cast(beanManager.getBeans(type, qualifiers));
        for (Bean bean : beans) {
            Object impl;
            A annotation;
            if (annotationClass == null) {
                Object impl2 = beanManager.getContext(bean.getScope()).get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
                consumer.accept(null, impl2);
                continue;
            }
            if (!CDIFactory.class.isAssignableFrom(bean.getBeanClass()) || CDIFactory.class.isAssignableFrom(type)) {
                annotation = bean.getBeanClass().getDeclaredAnnotation(annotationClass);
                if (annotation == null) continue;
                impl = beanManager.getContext(bean.getScope()).get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
                consumer.accept(annotation, impl);
                continue;
            }
            annotation = bean.getBeanClass().getDeclaredAnnotation(annotationClass);
            if (annotation == null) {
                Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(bean.getBeanClass()));
                annotation = factoryMethod.getDeclaredAnnotation(annotationClass);
            }
            if (annotation == null) continue;
            impl = beanManager.getContext(bean.getScope()).get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
            consumer.accept(annotation, impl);
        }
    }

    public static void scanSuppliers(BeanManager beanManager, Annotation[] qualifiers, Class<?> elementType, Consumer<CDISupplier> consumer) {
        Set beans = (Set)ObjectUtils.cast(beanManager.getBeans(CDISupplier.class, qualifiers));
        for (Bean bean : beans) {
            CDISupplier impl;
            Supplier annotation;
            if (!CDIFactory.class.isAssignableFrom(bean.getBeanClass())) {
                annotation = bean.getBeanClass().getDeclaredAnnotation(Supplier.class);
                if (annotation == null || annotation.value() != elementType) continue;
                impl = (CDISupplier)beanManager.getContext(bean.getScope()).get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
                consumer.accept(impl);
                continue;
            }
            annotation = bean.getBeanClass().getDeclaredAnnotation(Supplier.class);
            if (annotation == null) {
                Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(bean.getBeanClass()));
                annotation = factoryMethod.getDeclaredAnnotation(Supplier.class);
            }
            if (annotation == null || annotation.value() != elementType) continue;
            impl = (CDISupplier)beanManager.getContext(bean.getScope()).get((Contextual)bean, beanManager.createCreationalContext((Contextual)bean));
            consumer.accept(impl);
        }
    }

    public static <T, A extends Annotation> void scanBeans(BeanManager beanManager, Class<T> type, Annotation[] qualifiers, Class<A> annotationClass, Consumer<Class<?>> consumer) {
        Set beans = (Set)ObjectUtils.cast(beanManager.getBeans(type, qualifiers));
        for (Bean bean : beans) {
            if (annotationClass == null) {
                consumer.accept(bean.getBeanClass());
                continue;
            }
            if (!CDIFactory.class.isAssignableFrom(bean.getBeanClass()) || CDIFactory.class.isAssignableFrom(type)) {
                A annotation = bean.getBeanClass().getDeclaredAnnotation(annotationClass);
                if (annotation == null) continue;
                consumer.accept(bean.getBeanClass());
                continue;
            }
            Method factoryMethod = CDIUtils.getFactoryMethod((Class)ObjectUtils.cast(bean.getBeanClass()));
            if (bean.getBeanClass().getDeclaredAnnotation(annotationClass) == null && factoryMethod.getDeclaredAnnotation(annotationClass) == null) continue;
            consumer.accept(factoryMethod.getReturnType());
        }
    }

    public static Method getFactoryMethod(Class<? extends CDIFactory<?>> factoryClass) {
        try {
            return factoryClass.getMethod("produce", new Class[0]);
        }
        catch (ReflectiveOperationException ex) {
            return null;
        }
    }
}

