/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.TextGenerator;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.BaseEncodingUtils;
import com.appslandia.common.utils.MathUtils;
import com.appslandia.common.utils.RandomUtils;
import com.appslandia.common.utils.ValueUtils;
import java.security.SecureRandom;
import java.util.Random;

public class TokenGenerator
extends InitializeObject
implements TextGenerator {
    private int tokenLength;
    final Random random = new SecureRandom();

    public TokenGenerator() {
    }

    public TokenGenerator(int tokenLength) {
        this.tokenLength = tokenLength;
    }

    @Override
    protected void init() throws Exception {
        this.tokenLength = ValueUtils.valueOrDefault(this.tokenLength, 32);
        AssertUtils.assertTrue(this.tokenLength > 0, "tokenLength is required.");
    }

    @Override
    public String generate() {
        this.initialize();
        int len = MathUtils.ceil(this.tokenLength, 4);
        byte[] bytes = RandomUtils.nextBytes(this.random, len * 3 / 4);
        String urlBase64 = BaseEncodingUtils.urlEncodeBase64ToString(bytes);
        return urlBase64.length() == this.tokenLength ? urlBase64 : urlBase64.substring(0, this.tokenLength);
    }

    public TokenGenerator setTokenLength(int tokenLength) {
        this.assertNotInitialized();
        this.tokenLength = tokenLength;
        return this;
    }
}

