/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import java.io.IOException;
import java.io.Writer;

public class StringWriter
extends Writer {
    private StringBuilder buf;

    public StringWriter() {
        this.buf = new StringBuilder();
    }

    public StringWriter(int capacity) {
        this.buf = new StringBuilder(capacity);
    }

    @Override
    public void write(int c) {
        this.buf.append((char)c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buf.append(cbuf, off, len);
    }

    @Override
    public void write(String str) {
        this.buf.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.buf.append(str.substring(off, off + len));
    }

    @Override
    public StringWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public StringWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public StringWriter append(char c) {
        this.write(c);
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    public StringBuilder getBuffer() {
        return this.buf;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

